/**
 * Project Name:media-common<br>
 * File Name:SlotPictureSizeEnmu.java<br>
 * Package Name:cn.com.duiba.tuia.media.common.constants<br>
 * Date:2016年10月19日下午7:52:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.media.common.constants;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName: SlotPictureSizeEnmu <br/>
 * Function: 广告位尺寸大小枚举. <br/>
 * date: 2016年10月19日 下午7:52:36 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public enum SlotPictureSizeEnmu {

    /** 700*280 */
    SIZE_0(0, 700, 280),

    /** 225*140 */
    SIZE_1(1, 225, 140),

    /** 600*270 */
    SIZE_2(2, 600, 270),

    /** 640*960 */
    SIZE_3(3, 640, 960),

    /** 800*120 */
    SIZE_4(4, 800, 120),

    /** 140*140 */
    SIZE_5(5, 140, 140),

    /** 1280*720 */
    SIZE_6(6, 1280, 720),

    /** 150*150 */
    SIZE_21(21, 150, 150),

    /** 510*510 */
    SIZE_41(41, 510, 510),

    /** 510*510（1：1）透明底. */
    SIZE_42(42, 510, 510),

    /** 640*150 */
    SIZE_61(61, 640, 150),

    /** 640*280 */
    SIZE_81(81, 640, 280),

    /** 750*1334 */
    SIZE_91(91, 750, 1334),

    /** 600*300 */
    SIZE_92(92, 600, 300),

    /** 640*960 */
    SIZE_93(93, 640, 960),

    /** 720*1000 */
    SIZE_94(94, 720, 1000),

    /** 345*415 */
    SIZE_95(95, 345, 415),

    ;

    /** 图片尺寸ID. */
    private int sizeId;

    /** 宽. */
    private int width;

    /** 高. */
    private int height;

    private SlotPictureSizeEnmu(int sizeId, int width, int height) {
        this.sizeId = sizeId;
        this.width = width;
        this.height = height;
    }

    public int getSizeId() {
        return sizeId;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    /**
     * 
     * getPictureSizeById:(根据sizeId查询具体的尺寸). <br/>
     *
     * @author ZFZ
     * @param sizeId
     * @return
     * @since JDK 1.6
     */
    public static PictureSize getPictureSizeById(int sizeId) {
        SlotPictureSizeEnmu[] values = SlotPictureSizeEnmu.values();
        for (SlotPictureSizeEnmu value : values) {
            if (sizeId == value.getSizeId()) {
                return new PictureSize(value.getWidth(), value.getHeight());
            }
        }
        return null;
    }

    /**
     * 
     * getPictureSizeStr:(获取图片大小字符串). <br/>
     *
     * @author ZFZ
     * @param sizeId
     * @return
     * @since JDK 1.6
     */
    public static String getPictureSizeStr(int sizeId) {
        PictureSize pictureSize = getPictureSizeById(sizeId);
        String pictureSizeStr = "";
        if (pictureSize != null) {
            StringBuilder buildStr = new StringBuilder();
            pictureSizeStr = buildStr.append(pictureSize.getWidth()).append("*").append(pictureSize.getHeight()).toString();
            if ("*".equals(pictureSizeStr)) {
                return StringUtils.EMPTY;
            }
            return pictureSizeStr;
        }
        return pictureSizeStr;
    }

    /**
     * 
     * ClassName: PictureSize <br/>
     * date: 2016年12月8日 下午5:24:15 <br/>
     *
     * @author ZFZ
     * @version SlotPictureSizeEnmu
     * @since JDK 1.6
     */
    public static class PictureSize {

        /** 宽. */
        private int width;

        /** 高. */
        private int height;

        /**
         * 
         * Creates a new instance of PictureSize.
         *
         * @param width
         * @param height
         */
        public PictureSize(int width, int height) {
            super();
            this.width = width;
            this.height = height;
        }

        /**
         * 
         * Creates a new instance of PictureSize.
         *
         */
        public PictureSize() {
            super();
        }

        public int getWidth() {
            return width;
        }

        public int getHeight() {
            return height;
        }

    }
}
