/**
 * 文件名： CollectionUtil.java 此类描述的是： 作者: sunjiangrong 创建时间: 2016年4月22日 下午4:19:58
 */
package cn.com.duiba.tuia.media.common.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 此类用来操作list <功能详细描述>
 * 
 * @author: sunjiangrong
 * @创建时间: 2016年4月22日 下午4:19:58
 * @version:
 */
public class CollectionUtil
{
	
    /** The log. */
    private static Logger log = LoggerFactory.getLogger(CollectionUtil.class);
    
	private CollectionUtil()
	{
		
	}
	
	/**
	 * 获取两个集合的不同元素 <一句话功能描述>
	 * 
	 * @param collmax
	 * @param collmin
	 * @return
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static Collection getDiffent(Collection collmax, Collection collmin)
	{
		Collection csReturn = new LinkedList();
		Collection max = collmax;
		Collection min = collmin;
		
		// 先比较大小,这样会减少后续map的if判断次数
		if (collmax.size() < collmin.size())
		{
			max = collmin;
			min = collmax;
		}
		// 直接指定大小,防止再散列
		Map<Object, Integer> map = new HashMap<>(max.size());
		for (Object object : max)
		{
			map.put(object, 1);
		}
		for (Object object : min)
		{
			if (map.get(object) == null)
			{
				csReturn.add(object);
			}
			else
			{
				map.put(object, 2);
			}
			
		}
		for (Map.Entry<Object, Integer> entry : map.entrySet())
		{
			if (entry.getValue() == 1)
			{
				csReturn.add(entry.getKey());
			}
		}
		
		return csReturn;
	}
	
	/**
	 * 判断两个集合中是否有相同的元素 <一句话功能描述>
	 * 
	 * @param collmax
	 * @param collmin
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	public static boolean haveSame(Collection collmax, Collection collmin)
	{
		if (collmax.isEmpty() || collmin.isEmpty())
		{
			return false;
		}
		Collection max = collmax;
		Collection min = collmin;
		// 先比较大小,这样会减少后续map的if判断次数
		if (collmax.size() < collmin.size())
		{
			max = collmin;
			min = collmax;
		}
		// 直接指定大小,防止再散列
		Map<Object, Integer> map = new HashMap<>(max.size());
		for (Object object : max)
		{
			map.put(object, 1);
		}
		for (Object object : min)
		{
			// 如果遇上相同的直接返回true
			if (map.get(object) != null)
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * 
	 * getFieldList:(获取列表中某一属性的列表,例如ID). <br/>
	 *
	 * @author ZFZ
	 * @param list
	 * @param fieldName
	 * @return
	 * @since JDK 1.6
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
    public static List<Long> getFieldList(List list, String fieldName) {
		if (list == null || list.isEmpty()) {
			return ListUtils.EMPTY_LIST;
		}
		try {
			List<Long> filedList = new ArrayList();
			StringBuilder sb = new StringBuilder(fieldName);
			sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
			String field = sb.toString();
			for (Object obj : list) {
				Class clazz = obj.getClass();
				Method method = clazz.getMethod("get" + field);
				Object value = method.invoke(obj);
				filedList.add((Long) value);
			}
			return filedList;
		} catch (Exception e) {
		    log.error(" CollectionUtil getFieldList has error , the msg = [{}]", e);
		    
			return ListUtils.EMPTY_LIST;
		}
	}
}
