/**
 * 文件名： HttpConnectionUtil.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月31日 上午11:45:52
 */
package cn.com.duiba.tuia.media.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * http连接工具类.
 *
 * @author: leiliang
 * @version:
 */
public class HttpConnectionUtils {

    private HttpConnectionUtils hcu;

    public HttpConnectionUtils getHttpConnectionUtils() {
        if (hcu == null) {
            hcu = new HttpConnectionUtils();
        }
        return hcu;
    }

    /**
     * Read content from get.
     *
     * @param getURL the get url
     * @return the string
     * @throws IOException the IO exception
     */
    public static String readContentFromGet(String getURL) throws IOException {

        URL getUrl = new URL(getURL);
        HttpURLConnection connection = (HttpURLConnection) getUrl.openConnection();

        connection.setConnectTimeout(2000);// 设置连接主机超时（单位：毫秒）
        connection.setReadTimeout(2000);// 设置从主机读取数据超时（单位：毫秒）

        // 建立与服务器的连接，并未发送数据

        connection.connect();
        // 发送数据到服务器并使用Reader读取返回的数据
        StringBuilder sBuffer = new StringBuilder();

        InputStream inStream;
        byte[] buf = new byte[1024];
        inStream = connection.getInputStream();
        for (int n; (n = inStream.read(buf)) != -1;) {
            sBuffer.append(new String(buf, 0, n, "UTF-8"));
        }
        inStream.close();
        connection.disconnect();// 断开连接

        return sBuffer.toString();
    }
}
