/**
 * 文件名： JsonUtils.java 此类描述的是： 作者: leiliang 创建时间: 2016年3月23日 上午10:48:33
 */
package cn.com.duiba.tuia.media.common.utils;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * json相关 <功能详细描述>
 * 
 * @author: leiliang
 * @version:
 */
public class JsonUtils {

    /** The logger. */
    private static Logger            logger = LoggerFactory.getLogger(JsonUtils.class);

    public static final ObjectMapper mapper = new ObjectMapper();

    /** json字符串 */
    private static String            jsonString;

    private JsonUtils                ju;

    public JsonUtils getJsonUtils() {
        if (ju == null) {
            ju = new JsonUtils();
        }
        return ju;
    }

    /**
     * jsonString.
     *
     * @return the jsonString
     * @since JDK 1.6
     */
    private static String getJsonString() {
        return jsonString;
    }

    /**
     * jsonString.
     *
     * @param jsonString the jsonString to set
     * @since JDK 1.6
     */
    public static void setJsonString(String jsonString) {
        JsonUtils.setJsonString(jsonString);
    }

    /**
     * 对象转JSON
     * 
     * @param response
     * @param obj
     */
    public static void objToJSON(HttpServletResponse response, final Object obj) {
        try {
            setResponse(response);
            JsonUtils.setJsonString(mapper.writeValueAsString(obj));
            PrintWriter out = response.getWriter();
            out.print(JsonUtils.getJsonString());
            out.close();
        } catch (IOException e) {
            logger.error("JsonUtils.objToJSON happen IOException", e);
        }
    }

    /**
     * 对象转json
     * 
     * @param obj
     * @return
     * @throws TuiaMediaException
     */
    public static String objectToString(Object obj) throws TuiaMediaException {
        try {
            return mapper.writeValueAsString(obj);
        } catch (Exception e) {
            logger.error("JsonUtils.objectToString happen Exception", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    /**
     * json转对象
     * 
     * @param clazz
     * @param json
     * @return
     * @throws TuiaMediaException
     */
    public static <T> T jsonToObject(Class<T> clazz, String json) throws TuiaMediaException {
        try {
            return mapper.readValue(json, clazz);
        } catch (Exception e) {
            logger.error("JsonUtils.jsonToObject happen Exception", e);
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
    }

    /**
     * 设置编码格式
     * 
     * @param response
     */
    public static void setResponse(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
    }
}
