package cn.com.duiba.tuia.media.common.utils;

import java.security.MessageDigest;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;

/**
 * ClassName: MessageDigestUtils <br/>
 * date: 2016年12月1日 下午4:17:31 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 */
public class MessageDigestUtils {

    /** The logger. */
    private static Logger      logger = LoggerFactory.getLogger(MessageDigestUtils.class);

    private MessageDigestUtils msgDigestUtils;

    public MessageDigestUtils getMessageDigestUtils() {
        if (msgDigestUtils == null) {
            msgDigestUtils = new MessageDigestUtils();
        }
        return msgDigestUtils;
    }

    /**
     * SHA:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param str
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    public static String sha(String str) throws TuiaMediaException {
        return messageDigest(str, "SHA");
    }

    /**
     * MD5:(这里用一句话描述这个方法的作用). <br/>
     *
     * @author ZFZ
     * @param str
     * @return
     * @throws TuiaMediaException
     * @since JDK 1.6
     */
    public static String md5(String str) throws TuiaMediaException {
        return messageDigest(str, "MD5");
    }

    private static String messageDigest(String str, String alg) throws TuiaMediaException {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(str.getBytes("UTF-8"));
            Base64 bs = new Base64();
            return bs.encodeToString(md.digest());
        } catch (Exception e) {
            logger.error(" MessageDigestUtils messageDigest is error the e = [{}] ", e);
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "编码异常");
        }
    }
}
