/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlotStrategy;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.constants.SlotPictureSizeEnmu;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.StrategyService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotBackendBOImpl
implements SlotBackendBo {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SlotService soltService;
    @Autowired
    private StrategyService strategyService;
    @Autowired
    private MediaAppService mediaAppService;

    @Override
    public Boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {
        List<SlotDto> slotDtoList = this.soltService.getListDetail(slotIds);
        if (CollectionUtils.isNotEmpty(slotDtoList)) {
            for (SlotDto slotDto : slotDtoList) {
                if (1 != slotDto.getCheckStatus() && 2 != slotDto.getCheckStatus()) continue;
                this.logger.error("the slot is checked id = [{}]", (Object)slotDto.getId());
                throw new TuiaMediaException(ErrorCode.E0304007);
            }
        }
        return this.soltService.batchUpdateCheckStatus(slotIds, checkType);
    }

    @Override
    public RspSlotDetailDto getSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = this.soltService.selectById(slotId);
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setElementType(this.getTargetList(sltoDto.getElementType()));
        if (sltoDto.getSlotType() == 2) {
            rspSlotDetailDto.setPictureSize(sltoDto.getPictureSize());
        }
        MediaAppDto mediaAppDto = this.mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        RspShieldStrategy rspShieldStrategy = this.strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }
        return rspSlotDetailDto;
    }

    @Override
    public RspSlotDetailDto getBackendSlotDetailById(Long slotId) throws TuiaMediaException {
        SlotDto sltoDto = this.soltService.selectById(slotId);
        RspSlotDetailDto rspSlotDetailDto = new RspSlotDetailDto();
        rspSlotDetailDto.setSlotId(sltoDto.getId());
        rspSlotDetailDto.setSlotName(sltoDto.getSlotName());
        rspSlotDetailDto.setSlotType(sltoDto.getSlotType());
        rspSlotDetailDto.setAppId(sltoDto.getAppId());
        rspSlotDetailDto.setElementType(this.getTargetList(sltoDto.getElementType()));
        if (sltoDto.getSlotType() == 2) {
            rspSlotDetailDto.setPictureSize(sltoDto.getPictureSize());
        } else if (0 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_41.getSizeId()));
        } else if (1 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_61.getSizeId()));
        } else if (3 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_81.getSizeId()));
        } else if (4 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_21.getSizeId()));
        } else if (5 == sltoDto.getSlotType()) {
            rspSlotDetailDto.setPictureSize(Integer.valueOf(SlotPictureSizeEnmu.SIZE_21.getSizeId()));
        } else {
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u5e7f\u544a\u4f4d\u7c7b\u578b\u672a\u77e5");
        }
        MediaAppDto mediaAppDto = this.mediaAppService.getMediaAppDto(sltoDto.getAppId());
        rspSlotDetailDto.setAppName(mediaAppDto.getAppName());
        Long strategyId = sltoDto.getStrategyId();
        RspShieldStrategy rspShieldStrategy = this.strategyService.getDetail(strategyId);
        if (strategyId != null && rspShieldStrategy != null) {
            rspSlotDetailDto.setStrategyId(strategyId);
            rspSlotDetailDto.setStrategyName(rspShieldStrategy.getStrategyName());
            rspSlotDetailDto.setIndustryFlag(rspShieldStrategy.isIndustryFlag());
            rspSlotDetailDto.setAdvertiserFlag(rspShieldStrategy.isAdvertiserFlag());
            rspSlotDetailDto.setShieldIndustries(rspShieldStrategy.getShieldIndustries());
            rspSlotDetailDto.setShieldAdvertisers(rspShieldStrategy.getShieldAdvertisers());
        }
        return rspSlotDetailDto;
    }

    private List<String> getTargetList(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return ListUtils.EMPTY_LIST;
        }
        return Arrays.asList(source.split(","));
    }

    @Override
    public Boolean updateSlotStrategy(ReqUpdateSlotStrategy param) throws TuiaMediaException {
        RspShieldStrategy rspShieldStrategy = this.strategyService.getDetail(param.getStrategyId());
        ReqShieldListStrategy req = new ReqShieldListStrategy();
        if (rspShieldStrategy != null) {
            req.setShieldIndustries(param.getShieldIndustries());
            req.setShieldAdvertisers(param.getShieldAdvertisers());
            req.setId(param.getStrategyId());
        }
        this.strategyService.updateSlotStrategy(req);
        return true;
    }
}

