/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteActivitySortBackendService;
import cn.com.duiba.tuia.media.common.constants.ActivityTypeConstant;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.domain.ActivityStatisticsDayDto;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.ActivityStatisticsDayService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteActivitySortBackendServiceImpl
extends BaseRemoteService
implements RemoteActivitySortBackendService {
    private static final long TIME_DIFFER = 1000000L;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivityStatisticsDayService activityStatisticsDayService;

    public DubboResult<List<RspActivityDto>> getByCondition(ReqActivitySort reqActivitySort) {
        try {
            List<ActivitySortDto> result = this.activitySortService.selectByCondition(reqActivitySort);
            if (result == null) {
                return DubboResult.successResult(null);
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(CollectionUtil.getFieldList(result, (String)"activityId"));
            HashMap<Long, ActivityDto> activityMap = new HashMap<Long, ActivityDto>(activityDtoList.size());
            for (ActivityDto activityDto : activityDtoList) {
                activityMap.put(activityDto.getActivityId(), activityDto);
            }
            ArrayList<RspActivityDto> rspActivityDtoList = new ArrayList<RspActivityDto>(result.size());
            List<ActivityStatisticsDayDto> activityStatisticsDayDtoList = this.activityStatisticsDayService.selectExposureAndLaunchAdvert(CollectionUtil.getFieldList(result, (String)"activityId"));
            HashMap<Long, Long> spmMap = new HashMap<Long, Long>(activityStatisticsDayDtoList.size());
            for (ActivityStatisticsDayDto activityStatisticsDayDto : activityStatisticsDayDtoList) {
                spmMap.put(activityStatisticsDayDto.getDuibaActivityId(), DataTool.calculateEcpm((Long)activityStatisticsDayDto.getLaunchAdvertCount(), (Long)activityStatisticsDayDto.getExposureCount()));
            }
            for (ActivitySortDto activitySortDto : result) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setActivityId(Long.valueOf(activitySortDto.getActivityId()));
                if (activityMap.get(activitySortDto.getActivityId()) != null) {
                    rspActivityDto.setActivityName(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getName());
                    rspActivityDto.setDelete(((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getDelete());
                    rspActivityDto.setActivityTypeName(ActivityTypeConstant.getTypeText((Integer)((ActivityDto)((Object)activityMap.get(activitySortDto.getActivityId()))).getType()));
                    rspActivityDto.setSpm((Long)spmMap.get(activitySortDto.getActivityId()));
                }
                rspActivityDtoList.add(rspActivityDto);
            }
            return DubboResult.successResult(rspActivityDtoList);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addActivitySort(Long activityAppId, List<Long> activityIds) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.activitySortService.getMaxSortValueActivitySortDto(activityAppId);
            if (result != null && result.getSort() >= sort) {
                sort = result.getSort() + 1000000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setActivityAppId(activityAppId);
            List<ActivitySortDto> existList = this.activitySortService.selectByCondition(reqActivitySort);
            HashMap<Long, Long> map = new HashMap<Long, Long>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                map.put(activitySortDto.getActivityId(), activitySortDto.getSort());
            }
            List<ActivityDto> activityDtoList = this.activityService.selectByActivityIds(activityIds);
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            for (ActivityDto activityDto : activityDtoList) {
                if (map.get(activityDto.getActivityId()) != null) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivityAppId(activityAppId);
                activitySortDto.setActivityId(activityDto.getActivityId());
                activitySortDto.setSort(sort);
                sort = sort + 1000000L;
                activitySortDtoList.add(activitySortDto);
            }
            if (activitySortDtoList.size() > 0) {
                this.activitySortService.insertBatchActivitySort(activitySortDtoList);
            }
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addActivitySort is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> addDefaultActivitySort(Long activityAppId) {
        ArrayList<Long> defaultIds = new ArrayList<Long>();
        try {
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setActivityAppId(Long.valueOf(0L));
            List<ActivitySortDto> defaultList = this.activitySortService.selectByCondition(reqActivitySort);
            for (ActivitySortDto activitySortDto : defaultList) {
                defaultIds.add(activitySortDto.getActivityId());
            }
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.addDefaultActivitySort is error");
            return this.exceptionFailure(e);
        }
        return this.addActivitySort(activityAppId, defaultIds);
    }

    public DubboResult<Boolean> removeActivity(Long activityAppId, Long activityId) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.deleteActivity(activityAppId, activityId));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.getByCondition is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> sort(Long activityAppId, Long activityId, int location) {
        try {
            return DubboResult.successResult((Object)this.activitySortService.sort(activityAppId, activityId, location));
        }
        catch (Exception e) {
            this.logger.error("RemoteActivitySortBackendServiceImpl.sort is error");
            return this.exceptionFailure(e);
        }
    }
}

