/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivityApp;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityAppDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAppDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.domain.ActivityAppDto;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqPageQueryMediaApp;
import cn.com.duiba.tuia.media.service.ActivityAppService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityAppServiceImpl
implements ActivityAppService {
    @Autowired
    private ActivityAppDAO activityAppDAO;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private MediaAppDao mediaAppDao;

    @Override
    @Transactional
    public boolean insertBatchActivityApp(List<Long> activityAppIds) throws TuiaMediaException {
        List<IdAndName> apps = this.mediaAppDao.selectAppIdAndName(activityAppIds);
        if (apps != null && apps.size() > 0) {
            List<ActivityAppDto> existApp = this.activityAppDAO.selectByActivityAppIds(activityAppIds);
            HashMap<Long, String> map = new HashMap<Long, String>(existApp.size());
            for (ActivityAppDto activityAppDto : existApp) {
                map.put(activityAppDto.getActivityAppId(), activityAppDto.getName());
            }
            ArrayList<ActivityAppDto> activityAppDtoList = new ArrayList<ActivityAppDto>(apps.size());
            for (IdAndName idAndName : apps) {
                if (map.get(idAndName.getId()) != null) continue;
                ActivityAppDto activityAppDto = new ActivityAppDto();
                activityAppDto.setActivityAppId(idAndName.getId());
                activityAppDto.setName(idAndName.getName());
                activityAppDtoList.add(activityAppDto);
            }
            this.activityAppDAO.insertBatch(activityAppDtoList);
        }
        return true;
    }

    @Override
    public boolean updateActivityApp(ActivityAppDto activityAppDto) throws TuiaMediaException {
        if (activityAppDto.getActivityAppId() == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        return this.activityAppDAO.update(activityAppDto) == 1;
    }

    @Override
    public List<ActivityAppDto> selectByCondition(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        return this.activityAppDAO.selectByCondition(reqActivityApp);
    }

    @Override
    @Transactional
    public boolean deleteActivityApp(Long activityAppId) throws TuiaMediaException {
        if (activityAppId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        this.activityAppDAO.delete(activityAppId);
        this.activitySortDAO.delete(activityAppId, null);
        return true;
    }

    @Override
    public List<RspActivityAppDto> searchActivityApp(ReqActivityApp reqActivityApp) throws TuiaMediaException {
        ReqPageQueryMediaApp reqPageQueryMediaApp = new ReqPageQueryMediaApp();
        reqPageQueryMediaApp.setAppId(reqActivityApp.getActivityAppId());
        reqPageQueryMediaApp.setAppName(reqActivityApp.getActivityAppName());
        reqPageQueryMediaApp.setPageSize(-1);
        List<MediaAppDto> appDtoList = this.mediaAppDao.selectMediaAppList(reqPageQueryMediaApp);
        if (appDtoList == null || appDtoList.size() == 0) {
            return null;
        }
        ArrayList<RspActivityAppDto> rspActivityAppDtoList = new ArrayList<RspActivityAppDto>(appDtoList.size());
        for (MediaAppDto mediaAppDto : appDtoList) {
            RspActivityAppDto rspActivityAppDto = new RspActivityAppDto();
            rspActivityAppDto.setActivityAppId(mediaAppDto.getAppId());
            rspActivityAppDto.setActivityAppName(mediaAppDto.getAppName());
            rspActivityAppDtoList.add(rspActivityAppDto);
        }
        return rspActivityAppDtoList;
    }
}

