/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ActivitySortServiceImpl
implements ActivitySortService {
    private static final long TIME_DIFFER = 1000000L;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private ActivityDAO activityDAO;

    @Override
    public boolean insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        return this.activitySortDAO.insertBatch(activitySortDtoList) > 0;
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        List<Long> ids;
        if (!(StringUtils.isEmpty((Object)reqActivitySort.getActivityName()) && reqActivitySort.getActivityType() == null || (ids = this.activityDAO.selectByTypeAndName(reqActivitySort.getActivityName(), reqActivitySort.getActivityType())) == null || ids.size() <= 0)) {
            reqActivitySort.setActivityIds(ids);
        }
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    @Override
    @Transactional
    public boolean deleteActivity(Long activityAppId, Long activityId) throws TuiaMediaException {
        if (activityAppId == null || activityId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (activityAppId.equals(0L)) {
            this.activityDAO.delete(activityId);
            activityAppId = null;
        }
        return this.activitySortDAO.delete(activityAppId, activityId) == 1;
    }

    @Override
    public ActivitySortDto getMaxSortValueActivitySortDto(Long activityAppId) throws TuiaMediaException {
        if (activityAppId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setActivityAppId(activityAppId);
        reqActivitySort.setSort("sort,gmt_modified");
        reqActivitySort.setOrder("desc");
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public boolean sort(Long activityAppId, Long activityId, int location) throws TuiaMediaException {
        if (activityAppId == null || activityId == null || location <= 0) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        if (location == 1) {
            ActivitySortDto firstSortActivity = this.getFirstSortActivity(activityAppId);
            if (firstSortActivity.getActivityId() == activityId.longValue()) {
                return true;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setActivityAppId(activityAppId);
            reqActivitySort.setActivityId(activityId);
            List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
            if (result == null || result.size() == 0) {
                throw new TuiaMediaException(ErrorCode.E0501001);
            }
            ActivitySortDto activitySortDto = result.get(0);
            activitySortDto.setSort(firstSortActivity.getSort() - 1000000L);
            this.activitySortDAO.update(activitySortDto);
            return true;
        }
        List<ActivitySortDto> result = this.getLocationSortActivity(activityAppId, location);
        if (result.size() != 2) {
            throw new TuiaMediaException(ErrorCode.E0501002);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setActivityAppId(activityAppId);
        reqActivitySort.setActivityId(activityId);
        List<ActivitySortDto> rst = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result == null || result.size() == 0) {
            throw new TuiaMediaException(ErrorCode.E0501001);
        }
        ActivitySortDto activitySortDto = rst.get(0);
        if (result.get(1).getSort() == activitySortDto.getSort()) {
            return true;
        }
        if (result.get(0).getSort() == activitySortDto.getSort()) {
            activitySortDto.setSort(result.get(1).getSort() + 1000000L);
        } else {
            activitySortDto.setSort((result.get(0).getSort() + result.get(1).getSort()) / 2L);
        }
        this.activitySortDAO.update(activitySortDto);
        return true;
    }

    private ActivitySortDto getFirstSortActivity(Long activityAppId) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setActivityAppId(activityAppId);
        reqActivitySort.setOrder("asc");
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        reqActivitySort.setSort("sort,gmt_modified");
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    private List<ActivitySortDto> getLocationSortActivity(Long activityAppId, int location) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setActivityAppId(activityAppId);
        reqActivitySort.setOrder("asc");
        reqActivitySort.setRowStart(location - 2);
        reqActivitySort.setPageSize(Integer.valueOf(2));
        reqActivitySort.setSort("sort,gmt_modified");
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        return result;
    }
}

