/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.AccountDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqCreateSlot;
import cn.com.duiba.tuia.media.model.req.ReqEditSlotEnableStatus;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspSlot;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.tuia.media.utils.StringTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotServiceImpl
implements SlotService {
    @Autowired
    private SlotDAO slotDAO;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private AccountDAO accountDAO;

    @Override
    public Boolean insert(ReqCreateSlot req) throws TuiaMediaException {
        SlotDto slotDto = new SlotDto();
        slotDto.setMediaId(req.getMediaId());
        slotDto.setSlotName(req.getSlotName());
        slotDto.setEnableStatus(Integer.valueOf(0));
        slotDto.setSlotType(req.getSlotType());
        slotDto.setCheckStatus(Integer.valueOf(0));
        slotDto.setElementType(StringTool.getStringByList(req.getElementType()));
        slotDto.setAppId(req.getAppId());
        slotDto.setPictureSize(req.getPictureSize());
        slotDto.setStrategyId(req.getStrategyId());
        this.slotDAO.insert(slotDto);
        if (slotDto.getStrategyId() != null) {
            this.slotCacheService.updateSlotCache(slotDto.getId());
        }
        return true;
    }

    @Override
    public Boolean update(ReqUpdateSlot param) throws TuiaMediaException {
        SlotDto slotDto = new SlotDto();
        slotDto.setId(param.getSlotId());
        slotDto.setSlotName(param.getSlotName());
        slotDto.setEnableStatus(Integer.valueOf(0));
        slotDto.setSlotType(param.getSlotType());
        slotDto.setAppId(param.getAppId());
        slotDto.setCheckStatus(Integer.valueOf(0));
        slotDto.setElementType(StringTool.getStringByList(param.getElementType()));
        slotDto.setMediaId(param.getMediaId());
        slotDto.setPictureSize(param.getPictureSize());
        slotDto.setStrategyId(param.getStrategyId());
        this.slotDAO.update(slotDto);
        if (slotDto.getStrategyId() != null) {
            this.slotCacheService.updateSlotCache(slotDto.getId());
        }
        return true;
    }

    @Override
    public RspPageResult<RspSlot> selectListByPage(ReqSlotList param) throws TuiaMediaException {
        int count = this.slotDAO.selectAmountByPage(param);
        ArrayList<RspSlot> rspSlots = null;
        if (count > 0 && count >= param.getRowStart()) {
            List<SlotDto> slotDtos = this.slotDAO.selectListByPage(param);
            int size = slotDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            for (SlotDto slot : slotDtos) {
                appIds.add(slot.getAppId());
            }
            List<IdAndName> appIdAndNameList = this.mediaAppDao.selectAppIdAndName(appIds);
            HashMap<Long, String> appMap = new HashMap<Long, String>(size);
            for (IdAndName appVO : appIdAndNameList) {
                appMap.put(appVO.getId(), appVO.getName());
            }
            rspSlots = new ArrayList<RspSlot>(size);
            for (SlotDto slot : slotDtos) {
                RspSlot rspSlot = new RspSlot();
                rspSlot.setSlotId(slot.getId());
                rspSlot.setSlotName(slot.getSlotName());
                rspSlot.setAppId(slot.getAppId());
                rspSlot.setAppName((String)appMap.get(slot.getAppId()));
                rspSlot.setCheckStatus(slot.getCheckStatus());
                rspSlot.setModifiedDate(new DateTime((Object)slot.getGmtModified()).toString("yyyy-MM-dd"));
                rspSlot.setSlotType(slot.getSlotType());
                rspSlot.setEnableStatus(slot.getEnableStatus());
                rspSlot.setSlotType(slot.getSlotType());
                rspSlots.add(rspSlot);
            }
        }
        return new RspPageResult<RspSlot>(count, rspSlots, param.getPageSize());
    }

    @Override
    public SlotDto selectById(Long slotId) throws TuiaMediaException {
        return this.slotDAO.selectById(slotId);
    }

    @Override
    public Boolean updateEnableStatus(ReqEditSlotEnableStatus param) throws TuiaMediaException {
        long slotId = param.getSlotId();
        SlotDto slotDto = this.selectById(slotId);
        Integer enableStatus = param.getEnableStatus() != false ? 1 : 0;
        if (this.checkAppAndMediaStatus(enableStatus, slotDto)) {
            this.slotDAO.updateEnableStatus(slotId, enableStatus);
            this.slotCacheService.updateSlotCache(slotId);
        }
        return true;
    }

    private boolean checkAppAndMediaStatus(int enableStatus, SlotDto adsenseDto) throws TuiaMediaException {
        if (1 != adsenseDto.getCheckStatus()) {
            throw new TuiaMediaException(ErrorCode.E0304006);
        }
        return true;
    }

    @Override
    public PageResultDto<RspAdsenseSlotListDto> selectAdsenseListByPage(ReqGetSlotsByPageDto req) throws TuiaMediaException {
        String appName = req.getAppName();
        List<Long> appIdsList = null;
        if (StringUtils.isNotBlank((CharSequence)appName) && CollectionUtils.isEmpty(appIdsList = this.mediaAppDao.selectIdsByName(appName))) {
            return new PageResultDto(0, null, req.getPageSize().intValue());
        }
        int count = this.slotDAO.selectAdsenseAmountByPage(req, appIdsList);
        ArrayList<RspAdsenseSlotListDto> rspSlots = null;
        if (count > 0 && count >= req.getRowStart()) {
            List<SlotDto> slotDtos = this.slotDAO.selectListAdsenseByPage(req, appIdsList);
            int size = slotDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            for (SlotDto slot : slotDtos) {
                appIds.add(slot.getAppId());
            }
            List<IdAndName> appIdAndNameList = this.mediaAppDao.selectAppIdAndName(appIds);
            HashMap<Long, String> appMap = new HashMap<Long, String>(size);
            for (IdAndName appVO : appIdAndNameList) {
                appMap.put(appVO.getId(), appVO.getName());
            }
            rspSlots = new ArrayList<RspAdsenseSlotListDto>(size);
            for (SlotDto slotDto : slotDtos) {
                RspAdsenseSlotListDto rspDto = new RspAdsenseSlotListDto();
                rspDto.setAppId(slotDto.getAppId());
                rspDto.setAppName((String)appMap.get(slotDto.getAppId()));
                rspDto.setCheckStatus(slotDto.getCheckStatus());
                rspDto.setCreateDate(new DateTime((Object)slotDto.getGmtCreate()).toString("yyyy-MM-dd"));
                rspDto.setSlotId(slotDto.getId());
                rspDto.setSlotName(slotDto.getSlotName());
                rspDto.setSlotType(slotDto.getSlotType());
                rspSlots.add(rspDto);
            }
        }
        return new PageResultDto(count, rspSlots, req.getPageSize().intValue());
    }

    @Override
    public boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {
        this.slotDAO.batchUpdateCheckStatus(slotIds, checkType);
        if (checkType == 1) {
            this.slotDAO.batchUpdateEnableStatus(slotIds, 1);
        }
        this.slotCacheService.updatebatchSlotCache(slotIds);
        return true;
    }

    @Override
    public List<SlotDto> getListDetail(List<Long> slotIds) throws TuiaMediaException {
        return this.slotDAO.selectListDetail(slotIds);
    }

    @Override
    public List<Long> selectIdsByName(String slotName) throws TuiaMediaException {
        return this.slotDAO.selectIdsByName(slotName);
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException {
        return this.slotDAO.selectAppIdAndName(slotIds);
    }
}

