/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.StrategyDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ShieldStrategyDAO;
import cn.com.duiba.tuia.media.domain.ShieldStrategyDto;
import cn.com.duiba.tuia.media.model.req.ReqShieldListStrategy;
import cn.com.duiba.tuia.media.model.req.ReqShieldStrategy;
import cn.com.duiba.tuia.media.model.req.ReqStrategyPageQuery;
import cn.com.duiba.tuia.media.model.rsp.RspIdAndValue;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspShieldStrategy;
import cn.com.duiba.tuia.media.model.rsp.RspStrategyList;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.tuia.media.utils.CacheKeyUtils;
import cn.com.duiba.tuia.media.utils.RemoveDuplicateTool;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.utils.StringTool;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StrategyServiceImpl
implements StrategyService {
    private static final int ONE_WEEK = 604800;
    @Autowired
    private ShieldStrategyDAO shieldStrategyDAO;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private SlotCacheService slotCacheService;

    @Override
    public RspPageResult<RspStrategyList> getPageList(ReqStrategyPageQuery req) throws TuiaMediaException {
        int amount = this.shieldStrategyDAO.selectAmountByPage(req);
        ArrayList<RspStrategyList> strategies = null;
        if (amount > 0 && amount >= req.getRowStart()) {
            List<ShieldStrategyDto> strategyDtos = this.shieldStrategyDAO.selectListByPage(req);
            strategies = new ArrayList<RspStrategyList>(strategyDtos.size());
            for (ShieldStrategyDto strategyDto : strategyDtos) {
                RspStrategyList rspStrategy = new RspStrategyList();
                rspStrategy.setId(strategyDto.getId());
                rspStrategy.setStrategyName(strategyDto.getStrategyName());
                rspStrategy.setCreateDate(new DateTime((Object)strategyDto.getGmtCreate()).toString("yyyy-MM-dd"));
                if (StringUtils.isNotBlank((CharSequence)strategyDto.getShieldIndustries())) {
                    rspStrategy.setIndustryFlag(true);
                }
                if (StringUtils.isNotBlank((CharSequence)strategyDto.getShieldUrls())) {
                    rspStrategy.setAdvertiserFlag(true);
                }
                strategies.add(rspStrategy);
            }
        }
        return new RspPageResult<RspStrategyList>(amount, strategies, req.getPageSize());
    }

    @Override
    public Boolean delete(Long mediaId, Long strategyId) throws TuiaMediaException {
        if (this.isBelongMedia(strategyId, mediaId)) {
            this.shieldStrategyDAO.delete(strategyId);
        }
        this.redisClient.del(CacheKeyUtils.getStrategyKey(strategyId));
        return true;
    }

    private boolean isBelongMedia(Long strategyId, Long mediaId) throws TuiaMediaException {
        ShieldStrategyDto shieldStrategy = this.shieldStrategyDAO.selectById(strategyId);
        if (shieldStrategy == null) {
            throw new TuiaMediaException(ErrorCode.E0304002);
        }
        if (shieldStrategy.getMediaId() == null || mediaId.longValue() != shieldStrategy.getMediaId().longValue()) {
            throw new TuiaMediaException(ErrorCode.E0304001);
        }
        return true;
    }

    @Override
    public Boolean create(ReqShieldListStrategy param) throws TuiaMediaException {
        ReqShieldStrategy req = new ReqShieldStrategy();
        req.setStrategyName(param.getStrategyName());
        req.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        ArrayList<String> shieldAdvertisers = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(param.getShieldAdvertisers())) {
            for (String shieldAdvertiser : param.getShieldAdvertisers()) {
                shieldAdvertisers.add(shieldAdvertiser.trim());
            }
        }
        req.setShieldUrls(StringTool.getStringByList(RemoveDuplicateTool.doRemoveDuplicate(shieldAdvertisers)));
        req.setMediaId(RequestLocal.get().getCid());
        if (this.shieldStrategyDAO.isNotExist(null, req.getMediaId(), req.getStrategyName())) {
            this.shieldStrategyDAO.insert(req);
            StrategyDto cacheDto = new StrategyDto(req.getShieldIndustries(), req.getShieldUrls());
            this.redisClient.setex(CacheKeyUtils.getStrategyKey(req.getId()), 604800, JSONObject.toJSONString((Object)cacheDto));
        }
        return true;
    }

    @Override
    public Boolean update(ReqShieldListStrategy param) throws TuiaMediaException {
        ReqShieldStrategy req = new ReqShieldStrategy();
        req.setId(param.getId());
        req.setStrategyName(param.getStrategyName());
        req.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        ArrayList<String> shieldAdvertisers = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(param.getShieldAdvertisers())) {
            for (String shieldAdvertiser : param.getShieldAdvertisers()) {
                if (!StringUtils.isNotBlank((CharSequence)shieldAdvertiser)) continue;
                shieldAdvertisers.add(shieldAdvertiser.trim());
            }
        }
        req.setShieldUrls(StringTool.getStringByList(RemoveDuplicateTool.doRemoveDuplicate(shieldAdvertisers)));
        req.setMediaId(RequestLocal.get().getCid());
        if (this.isBelongMedia(req.getId(), req.getMediaId()) && this.shieldStrategyDAO.isNotExist(req.getId(), req.getMediaId(), req.getStrategyName())) {
            this.shieldStrategyDAO.update(req);
            StrategyDto cacheDto = new StrategyDto(req.getShieldIndustries(), req.getShieldUrls());
            this.redisClient.setex(CacheKeyUtils.getStrategyKey(req.getId()), 604800, JSONObject.toJSONString((Object)cacheDto));
        }
        return true;
    }

    @Override
    public Boolean updateSlotStrategy(ReqShieldListStrategy param) throws TuiaMediaException {
        ReqShieldStrategy req = new ReqShieldStrategy();
        req.setId(param.getId());
        req.setStrategyName(param.getStrategyName());
        req.setShieldIndustries(StringTool.getStringByList(param.getShieldIndustries()));
        ArrayList<String> shieldAdvertisers = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(param.getShieldAdvertisers())) {
            for (String shieldAdvertiser : param.getShieldAdvertisers()) {
                if (!StringUtils.isNotBlank((CharSequence)shieldAdvertiser)) continue;
                shieldAdvertisers.add(shieldAdvertiser.trim());
            }
        }
        req.setShieldUrls(StringTool.getStringByList(RemoveDuplicateTool.doRemoveDuplicate(shieldAdvertisers)));
        this.shieldStrategyDAO.update(req);
        StrategyDto cacheDto = new StrategyDto(req.getShieldIndustries(), req.getShieldUrls());
        this.redisClient.setex(CacheKeyUtils.getStrategyKey(req.getId()), 604800, JSONObject.toJSONString((Object)cacheDto));
        return true;
    }

    @Override
    public List<RspIdAndValue> getListByMediaId(Long mediaId) throws TuiaMediaException {
        List<ShieldStrategyDto> strategyDtos = this.shieldStrategyDAO.selectListByMediaId(mediaId);
        ArrayList<RspIdAndValue> rspIdAndValue = new ArrayList<RspIdAndValue>(strategyDtos.size());
        for (ShieldStrategyDto strategyDto : strategyDtos) {
            RspIdAndValue dto = new RspIdAndValue();
            dto.setId(Long.toString(strategyDto.getId()));
            dto.setValue(strategyDto.getStrategyName());
            rspIdAndValue.add(dto);
        }
        return rspIdAndValue;
    }

    @Override
    public RspShieldStrategy getDetail(Long strategyId) throws TuiaMediaException {
        ShieldStrategyDto shield = this.shieldStrategyDAO.selectById(strategyId);
        RspShieldStrategy shieldStrategy = null;
        if (shield != null) {
            shieldStrategy = new RspShieldStrategy();
            shieldStrategy.setId(strategyId);
            if (StringUtils.isNotBlank((CharSequence)shield.getShieldIndustries())) {
                shieldStrategy.setIndustryFlag(true);
            }
            if (StringUtils.isNotBlank((CharSequence)shield.getShieldUrls())) {
                shieldStrategy.setAdvertiserFlag(true);
            }
            shieldStrategy.setShieldIndustries(this.getTargetList(shield.getShieldIndustries()));
            shieldStrategy.setShieldAdvertisers(this.getTargetList(shield.getShieldUrls()));
            shieldStrategy.setStrategyName(shield.getStrategyName());
        }
        return shieldStrategy;
    }

    private List<String> getTargetList(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return ListUtils.EMPTY_LIST;
        }
        return Arrays.asList(source.split(","));
    }
}

