/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.MD5;
import cn.com.duiba.tuia.media.model.Captcha;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiYanTool {
    private static final String GEETEST_URL = "api.geetest.com";
    private static final String VALI_DATE_URL = "/validate.php";
    private static final int PORT_80 = 80;
    private static final String VER_NAME = "2.15.7.3.1";
    private static final String SDK_LANG = "java";
    private static Logger logger = LoggerFactory.getLogger(JiYanTool.class);
    private static final String DEFAULT_CAPTCHA_ID = "9fbc62e56634523d27bc451b1a6a0443";
    private static final String DEFAULT_PRIVATE_KEY = "979d8ac2255f30f1ef8a8ca6ba681100";
    private static String jiYanPrivateKey;
    private static String jiYanCaptchaId;

    public static void setJiYanPrivateKey(String jiYanPrivateKey) {
        JiYanTool.jiYanPrivateKey = jiYanPrivateKey;
    }

    public static void setJiYanCaptchaId(String jiYanCaptchaId) {
        JiYanTool.jiYanCaptchaId = jiYanCaptchaId;
    }

    public static String getJiYanPrivateKey() {
        if (StringUtils.isBlank((String)jiYanPrivateKey)) {
            return DEFAULT_PRIVATE_KEY;
        }
        return jiYanPrivateKey;
    }

    public static String getJiYanCaptchaId() {
        if (StringUtils.isBlank((String)jiYanCaptchaId)) {
            return DEFAULT_CAPTCHA_ID;
        }
        return jiYanCaptchaId;
    }

    public static void authJiYanCode(Captcha captchaVO) throws TuiaMediaException {
        String seccode = null;
        String validate = null;
        if (captchaVO == null || StringUtils.isBlank((String)captchaVO.getChallenge()) || StringUtils.isBlank((String)(seccode = captchaVO.getSeccode())) || StringUtils.isBlank((String)(validate = captchaVO.getValidate()))) {
            logger.error("authJiYanCode error, because the param =[{}]", (Object)captchaVO);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }
        String query = String.format("seccode=%s&sdk=%s", seccode, "java_2.15.7.3.1");
        String response = "";
        String encodeStr = MD5.md5((String)(JiYanTool.getJiYanPrivateKey() + "geetest" + captchaVO.getChallenge()));
        if (!StringUtils.equals((String)validate, (String)encodeStr)) {
            logger.error("authJiYanCode error, because the encodeStr=[{}], and the validate =[{}]", (Object)encodeStr, (Object)validate);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }
        response = JiYanTool.doAuthJiYanCode(query);
        if (!response.equals(MD5.md5((String)seccode))) {
            logger.error("authJiYanCode error, because the response not equal seccode, and the response is:" + response);
            throw new TuiaMediaException(ErrorCode.E0001007);
        }
    }

    private static String doAuthJiYanCode(String data) throws TuiaMediaException {
        Socket socket = null;
        try {
            String line;
            String response = "error";
            InetAddress addr = InetAddress.getByName(GEETEST_URL);
            socket = new Socket(addr, 80);
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            wr.write("POST /validate.php HTTP/1.0\r\n");
            wr.write("Host: api.geetest.com\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("\r\n");
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
            while ((line = rd.readLine()) != null) {
                response = line;
            }
            wr.close();
            rd.close();
            String string = response;
            return string;
        }
        catch (Exception e) {
            logger.error("doAuthJiYanCode error, the data=[{}]", (Object)data, (Object)e);
            throw new TuiaMediaException(ErrorCode.E0001007, (Throwable)e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    logger.error("doAuthJiYanCode happen IOException", (Throwable)e);
                }
            }
        }
    }
}

