/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.remoteservice.RemoteMediaServiceImpl;
import cn.com.duiba.wolf.dubbo.DubboResult;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

public class RemoteTestController {
    @Autowired
    private RemoteMediaServiceImpl remoteMediaServiceImpl;

    private <T> DubboResult<T> failResult(Exception e) {
        if (e instanceof TuiaMediaException) {
            TuiaMediaException e1 = (TuiaMediaException)((Object)e);
            return DubboResult.failResult((String)e1.getResultCode(), (String)e1.getMessage());
        }
        return DubboResult.failResult((String)ErrorCode.E9999999.getErrorCode(), (String)"\u672a\u77e5\u9519\u8bef");
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565", httpMethod="GET", notes="\u67e5\u8be2\u5c4f\u853d\u7b56\u7565\u63a5\u53e3")
    @RequestMapping(value={"/getStrategy"}, method={RequestMethod.GET})
    DubboResult<StrategyDto> getStrategy(@RequestParam long slotId) {
        try {
            return this.remoteMediaServiceImpl.getStrategy(slotId);
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5224\u65ad\u5a92\u4f53\u5e94\u7528\u662f\u5426\u6709\u6548", httpMethod="GET", notes="\u5224\u65ad\u5a92\u4f53\u5e94\u7528\u662f\u5426\u6709\u6548\u63a5\u53e3")
    @RequestMapping(value={"/isValidMediaApp"}, method={RequestMethod.GET})
    DubboResult<Boolean> isValidMediaApp(@RequestParam long mediaAppId) {
        try {
            return this.remoteMediaServiceImpl.isValidMediaApp(mediaAppId);
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5a92\u4f53\u5e94\u7528", httpMethod="GET", notes="\u67e5\u8be2\u5a92\u4f53\u5e94\u7528\u63a5\u53e3")
    @RequestMapping(value={"/getMediaApp"}, method={RequestMethod.GET})
    DubboResult<MediaAppDataDto> getMediaApp(@RequestParam long mediaAppId) {
        try {
            return this.remoteMediaServiceImpl.getMediaApp(mediaAppId);
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u4f4d", httpMethod="GET", notes="\u67e5\u8be2\u5e7f\u544a\u4f4d\u63a5\u53e3")
    @RequestMapping(value={"/getSlot"}, method={RequestMethod.GET})
    DubboResult<SlotCacheDto> getSlot(@RequestParam long slotId) {
        try {
            return this.remoteMediaServiceImpl.getSlot(slotId);
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u5e7f\u544a\u4f4d\u5c4f\u853d\u7b56\u7565\u7f13\u5b58", httpMethod="POST", notes="\u66f4\u65b0\u5e7f\u544a\u4f4d\u5c4f\u853d\u7b56\u7565\u7f13\u5b58\u63a5\u53e3")
    @RequestMapping(value={"/updateStrategy"}, method={RequestMethod.POST})
    DubboResult<StrategyDto> updateStrategy(@RequestParam long slotId) {
        try {
            return this.remoteMediaServiceImpl.updateStrategy(slotId);
        }
        catch (Exception e) {
            return this.failResult(e);
        }
    }
}

