/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotLineStatisticsDto;
import cn.com.duiba.tuia.media.bo.SlotLineStatisticsBO;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/slotLineStatistics"})
@Api(value="\u7ed3\u7b97\u6570\u636e\u7edf\u8ba1")
public class SlotLineStatisticsController
extends BaseController {
    @Autowired
    private SlotLineStatisticsBO slotLineStatisticsBo;

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u6298\u7ebf\u7edf\u8ba1\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u6298\u7ebf\u7edf\u8ba1\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"getStatisticsDataByDate"}, method={RequestMethod.GET})
    public Result<RspSlotLineStatisticsDto> getStatisticsDataByDate(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param, BindingResult result) {
        try {
            this.checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.slotLineStatisticsBo.selectStatisticsDataByDate(param));
        }
        catch (TuiaMediaException e) {
            this.logger.info("DataStatisticsController.getStatisticsDataByDate error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5a92\u4f53app\u7edf\u8ba1\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u5a92\u4f53app\u7edf\u8ba1\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"getMediaAppData"}, method={RequestMethod.GET})
    public Result<PageResultDto<RspMediaAppDataStatisticsDto>> getMediaAppData(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param, BindingResult result) {
        try {
            this.checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.slotLineStatisticsBo.getMediaAppStatisticsData(param));
        }
        catch (TuiaMediaException e) {
            this.logger.info("DataStatisticsController.getMediaAppData error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u4f4d\u7edf\u8ba1\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u5e7f\u544a\u4f4d\u7edf\u8ba1\u6570\u636e\u63a5\u53e3")
    @RequestMapping(value={"getSlotData"}, method={RequestMethod.GET})
    public Result<PageResultDto<RspSlotDataStatisticsDto>> getSlotData(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param, BindingResult result) {
        try {
            this.checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return this.successResult(this.slotLineStatisticsBo.getSlotStatisticsData(param));
        }
        catch (TuiaMediaException e) {
            this.logger.info("DataStatisticsController.getSlotData error! the param=[{}]", (Object)param);
            return this.failResult((Exception)((Object)e));
        }
    }
}

