/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.core.api.dto.TagLevel;
import cn.com.duiba.tuia.core.api.remoteservice.RemoteTagBackendService;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.RemoveDuplicateTool;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tag"})
@Api(value="\u6807\u7b7e\u76f8\u5173api")
public class TagController
extends BaseController {
    @Autowired
    private RemoteTagBackendService remoteTagBackendService;

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u884c\u4e1a\u5206\u7c7b", httpMethod="GET", notes="\u67e5\u8be2\u884c\u4e1a\u5206\u7c7b\u63a5\u53e3")
    @RequestMapping(value={"/getIndustries"}, method={RequestMethod.GET})
    public Result<List<String>> getIndustries() {
        try {
            DubboResult dubboResult = this.remoteTagBackendService.getIndustries();
            this.doTuiaCoreException(dubboResult, "remoteTagBackendService.getIndustries");
            List result = (List)dubboResult.getResult();
            return this.successResult(RemoveDuplicateTool.doRemoveDuplicate((List)result));
        }
        catch (Exception e) {
            this.logger.error("TagController.getIndustries error!");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u884c\u4e1a\u6240\u6709\u6807\u7b7e", httpMethod="GET", notes="\u67e5\u8be2\u884c\u4e1a\u6240\u6709\u6807\u7b7e\u63a5\u53e3")
    @RequestMapping(value={"/getAllIndustries"}, method={RequestMethod.GET})
    public Result<List<String>> getAllIndustries() {
        try {
            DubboResult dubboResult = this.remoteTagBackendService.getAllIndustries();
            this.doTuiaCoreException(dubboResult, "remoteTagBackendService.getAllIndustries");
            List result = (List)dubboResult.getResult();
            List<Object> rspAllTags = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                rspAllTags = this.doGetTag(result);
            }
            return this.successResult(rspAllTags);
        }
        catch (Exception e) {
            this.logger.error("TagController.getAllIndustries error!");
            return this.failResult(e);
        }
    }

    private List<String> doGetTag(List<TagLevel> result) {
        List<String> rspAllTags = new ArrayList<String>();
        for (TagLevel tagLevel : result) {
            rspAllTags = this.doRecursion(rspAllTags, tagLevel);
        }
        return RemoveDuplicateTool.doRemoveDuplicate(rspAllTags);
    }

    private List<String> doRecursion(List<String> rspAllTags, TagLevel tagLevel) {
        if (CollectionUtils.isNotEmpty((Collection)tagLevel.getChildren())) {
            ArrayList<String> rsgTags = new ArrayList<String>();
            for (TagLevel tag : tagLevel.getChildren()) {
                rsgTags.add(tag.getText());
                this.doRecursion(rspAllTags, tag);
            }
            rspAllTags.addAll(rsgTags);
        }
        return rspAllTags;
    }
}

