/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5 {
    private static Logger logger = LoggerFactory.getLogger(MD5.class);
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String md5(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(b, 0, b.length);
        return MD5.byteArrayToHexString(md5.digest());
    }

    public static String md5(String data) throws TuiaMediaException {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] b = data.getBytes("UTF8");
            md5.update(b, 0, b.length);
            return MD5.byteArrayToHexString(md5.digest());
        }
        catch (Exception e) {
            logger.error("md5 error", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002002, (Throwable)e);
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(MD5.byteToHexString(b[i]));
        }
        return sb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
}

