/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.endpoint;

import com.taobao.top.link.LinkException;
import com.taobao.top.link.channel.ChannelContext;
import com.taobao.top.link.endpoint.Endpoint;
import com.taobao.top.link.endpoint.Identity;
import com.taobao.top.link.endpoint.Message;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointContext {
    private ChannelContext channelContext;
    private Endpoint endpoint;
    private Identity messageFrom;
    private Message origin;

    public EndpointContext(ChannelContext channelContext, Endpoint endpoint, Identity messageFrom, Message origin) {
        this.channelContext = channelContext;
        this.endpoint = endpoint;
        this.messageFrom = messageFrom;
        this.origin = origin;
    }

    public Identity getMessageFrom() {
        return this.messageFrom;
    }

    public Map<String, Object> getMessage() {
        return this.origin.content;
    }

    public void reply(Map<String, Object> message) throws LinkException {
        this.endpoint.send(this.channelContext.getSender(), this.createMessage(message));
    }

    public void error(int statusCode, String statusPhase) throws LinkException {
        Message msg = this.createMessage(null);
        msg.statusCode = statusCode;
        msg.statusPhase = statusPhase;
        this.endpoint.send(this.channelContext.getSender(), msg);
    }

    private Message createMessage(Map<String, Object> message) {
        Message msg = new Message();
        msg.protocolVersion = this.origin.protocolVersion;
        msg.messageType = (short)3;
        msg.flag = this.origin.flag;
        msg.token = this.origin.token;
        msg.content = message;
        return msg;
    }
}

