@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  media-deploy startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and MEDIA_DEPLOY_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\meida-deploy-0.1.0.jar;%APP_HOME%\lib\taobao-sdk-java-online_standard-20141128.jar;%APP_HOME%\lib\media-biz-0.0.1-xyn-SNAPSHOT.jar;%APP_HOME%\lib\media-common-0.0.1-xyn-SNAPSHOT.jar;%APP_HOME%\lib\aspectjrt-1.8.9.jar;%APP_HOME%\lib\aspectjweaver-1.8.9.jar;%APP_HOME%\lib\commons-fileupload-1.3.jar;%APP_HOME%\lib\commons-io-2.4.jar;%APP_HOME%\lib\spring-boot-starter-web-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-jdbc-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-test-1.2.2.RELEASE.jar;%APP_HOME%\lib\commons-dbcp2-2.1.1.jar;%APP_HOME%\lib\zkclient-0.1.jar;%APP_HOME%\lib\springfox-swagger-ui-2.2.2.jar;%APP_HOME%\lib\springfox-swagger2-2.2.2.jar;%APP_HOME%\lib\media-api-0.0.1-xyn-SNAPSHOT.jar;%APP_HOME%\lib\spring-data-redis-1.5.0.RELEASE.jar;%APP_HOME%\lib\jedis-2.8.1.jar;%APP_HOME%\lib\xmemcached-1.4.3.jar;%APP_HOME%\lib\spymemcached-2.8.4.jar;%APP_HOME%\lib\hibernate-validator-5.2.4.Final.jar;%APP_HOME%\lib\mybatis-3.3.1.jar;%APP_HOME%\lib\mybatis-spring-1.2.3.jar;%APP_HOME%\lib\mysql-connector-java-5.1.9.jar;%APP_HOME%\lib\spring-context-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-context-support-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-orm-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-beans-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-core-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-web-4.1.5.RELEASE.jar;%APP_HOME%\lib\commons-dbcp-1.4.jar;%APP_HOME%\lib\commons-collections4-4.1.jar;%APP_HOME%\lib\commons-lang3-3.4.jar;%APP_HOME%\lib\cglib-2.2.2.jar;%APP_HOME%\lib\guava-18.0.jar;%APP_HOME%\lib\dubbo-2.4.10.jar;%APP_HOME%\lib\zkclient-0.5.jar;%APP_HOME%\lib\rocketmq-client-3.4.6.jar;%APP_HOME%\lib\joda-time-2.9.3.jar;%APP_HOME%\lib\wolf-1.2.2-SNAPSHOT.jar;%APP_HOME%\lib\idmaker-service-api-1.1.6-SNAPSHOT.jar;%APP_HOME%\lib\developer-center-api-1.2.14-SNAPSHOT.jar;%APP_HOME%\lib\tuia-core-api-1.0.1-SNAPSHOT.jar;%APP_HOME%\lib\activity-center-api-1.2.7.4-SNAPSHOT.jar;%APP_HOME%\lib\aliyun-sdk-oss-2.0.1.jar;%APP_HOME%\lib\commons-codec-1.6.jar;%APP_HOME%\lib\commons-collections-3.2.jar;%APP_HOME%\lib\jackson-databind-2.3.3.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\bcprov-jdk15on-1.47.jar;%APP_HOME%\lib\json-20160212.jar;%APP_HOME%\lib\mail-1.4.jar;%APP_HOME%\lib\velocity-1.7.jar;%APP_HOME%\lib\log4j-over-slf4j-1.7.5.jar;%APP_HOME%\lib\slf4j-api-1.7.5.jar;%APP_HOME%\lib\spring-boot-starter-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-tomcat-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-webmvc-4.1.5.RELEASE.jar;%APP_HOME%\lib\spring-jdbc-4.1.5.RELEASE.jar;%APP_HOME%\lib\tomcat-jdbc-8.0.20.jar;%APP_HOME%\lib\spring-tx-4.1.5.RELEASE.jar;%APP_HOME%\lib\junit-4.12.jar;%APP_HOME%\lib\mockito-core-1.10.19.jar;%APP_HOME%\lib\hamcrest-core-1.3.jar;%APP_HOME%\lib\hamcrest-library-1.3.jar;%APP_HOME%\lib\spring-test-4.1.5.RELEASE.jar;%APP_HOME%\lib\commons-pool2-2.4.2.jar;%APP_HOME%\lib\commons-logging-1.1.2.jar;%APP_HOME%\lib\zookeeper-3.3.3.jar;%APP_HOME%\lib\springfox-spring-web-2.2.2.jar;%APP_HOME%\lib\mapstruct-1.0.0.CR1.jar;%APP_HOME%\lib\swagger-annotations-1.5.3.jar;%APP_HOME%\lib\swagger-models-1.5.3.jar;%APP_HOME%\lib\springfox-spi-2.2.2.jar;%APP_HOME%\lib\springfox-schema-2.2.2.jar;%APP_HOME%\lib\springfox-swagger-common-2.2.2.jar;%APP_HOME%\lib\classmate-1.2.0.jar;%APP_HOME%\lib\spring-plugin-core-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-plugin-metadata-1.2.0.RELEASE.jar;%APP_HOME%\lib\spring-hateoas-0.18.0.RELEASE.jar;%APP_HOME%\lib\dcommons-base-0.1.5.ll-SNAPSHOT.jar;%APP_HOME%\lib\commons-lang-2.6.jar;%APP_HOME%\lib\spring-aop-4.1.5.RELEASE.jar;%APP_HOME%\lib\validation-api-1.1.0.Final.jar;%APP_HOME%\lib\jboss-logging-3.2.1.Final.jar;%APP_HOME%\lib\spring-expression-4.1.5.RELEASE.jar;%APP_HOME%\lib\commons-pool-1.6.jar;%APP_HOME%\lib\asm-3.3.1.jar;%APP_HOME%\lib\javassist-3.15.0-GA.jar;%APP_HOME%\lib\netty-3.2.5.Final.jar;%APP_HOME%\lib\rocketmq-common-3.4.6.jar;%APP_HOME%\lib\fastjson-1.2.6.jar;%APP_HOME%\lib\activation-1.1.1.jar;%APP_HOME%\lib\antlr-3.4.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\bsh-2.0b1.jar;%APP_HOME%\lib\druid-1.0.18.jar;%APP_HOME%\lib\commons-beanutils-1.8.3.jar;%APP_HOME%\lib\commons-cli-1.2.jar;%APP_HOME%\lib\commons-math3-3.6.1.jar;%APP_HOME%\lib\logback-core-1.0.13.jar;%APP_HOME%\lib\logback-classic-1.0.13.jar;%APP_HOME%\lib\velocity-tools-2.0.jar;%APP_HOME%\lib\httpclient-4.4.1.jar;%APP_HOME%\lib\httpasyncclient-4.0.2.jar;%APP_HOME%\lib\duiba-service-api-1.6.7-SNAPSHOT.jar;%APP_HOME%\lib\jdom-1.1.jar;%APP_HOME%\lib\jackson-core-2.3.3.jar;%APP_HOME%\lib\spring-boot-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-autoconfigure-1.2.2.RELEASE.jar;%APP_HOME%\lib\spring-boot-starter-logging-1.2.2.RELEASE.jar;%APP_HOME%\lib\snakeyaml-1.14.jar;%APP_HOME%\lib\tomcat-embed-core-8.0.20.jar;%APP_HOME%\lib\tomcat-embed-el-8.0.20.jar;%APP_HOME%\lib\tomcat-embed-logging-juli-8.0.20.jar;%APP_HOME%\lib\tomcat-embed-websocket-8.0.20.jar;%APP_HOME%\lib\tomcat-juli-8.0.20.jar;%APP_HOME%\lib\objenesis-2.1.jar;%APP_HOME%\lib\jline-0.9.94.jar;%APP_HOME%\lib\springfox-core-2.2.2.jar;%APP_HOME%\lib\rocketmq-remoting-3.4.6.jar;%APP_HOME%\lib\antlr-runtime-3.4.jar;%APP_HOME%\lib\ST4-4.0.4.jar;%APP_HOME%\lib\commons-digester-1.8.jar;%APP_HOME%\lib\commons-chain-1.1.jar;%APP_HOME%\lib\commons-validator-1.3.1.jar;%APP_HOME%\lib\dom4j-1.1.jar;%APP_HOME%\lib\oro-2.0.8.jar;%APP_HOME%\lib\sslext-1.2-0.jar;%APP_HOME%\lib\struts-core-1.3.8.jar;%APP_HOME%\lib\struts-taglib-1.3.8.jar;%APP_HOME%\lib\struts-tiles-1.3.8.jar;%APP_HOME%\lib\httpcore-nio-4.3.2.jar;%APP_HOME%\lib\jcl-over-slf4j-1.7.10.jar;%APP_HOME%\lib\jul-to-slf4j-1.7.10.jar;%APP_HOME%\lib\netty-all-4.0.29.Final.jar;%APP_HOME%\lib\stringtemplate-3.2.1.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\jackson-annotations-2.4.5.jar;%APP_HOME%\lib\httpcore-4.4.1.jar

@rem Execute media-deploy
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %MEDIA_DEPLOY_OPTS%  -classpath "%CLASSPATH%" cn.com.duiba.tuia.media.web.Application %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable MEDIA_DEPLOY_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%MEDIA_DEPLOY_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
