/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.filter;

import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.RequestTool;
import cn.com.duiba.tuia.media.common.tool.TimeProfileTool;
import cn.com.duiba.tuia.media.common.utils.AjaxUtils;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.BaseService;
import cn.com.duiba.tuia.media.utils.CookieUtil;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.utils.ResultUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="loginFilter")
public class LoginFilter
extends BaseService
implements Filter {
    private Logger log = LoggerFactory.getLogger(LoginFilter.class);
    public static List<String> AUTH_FILTER_LIST = new ArrayList<String>();
    @Autowired
    private AccountService accountService;

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        TimeProfileTool.enter((String)"loginFilter.doFilter");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        RequestTool.setRequestInThreadLocal((HttpServletRequest)request);
        RequestLocal.clear();
        RequestLocal.get().setRequest(request);
        RequestLocal.get().setResponse(response);
        Long cid = RequestLocal.get().getCid();
        String path = request.getServletPath();
        if (!(path.startsWith("/webjars") || path.startsWith("/swagger") || AUTH_FILTER_LIST.contains(path))) {
            if (cid != null) {
                if ("/account/login".equals(path) || "/account/register".equals(path)) {
                    this.log.error("please enter the home page! the url is:" + path);
                    response.sendRedirect("/#/private");
                    return;
                }
                try {
                    this.accountStatusAuth(cid);
                }
                catch (TuiaMediaException e) {
                    CookieUtil.deleteCookie((String)"dataxyz345");
                    this.log.error("please login again! the url is:" + path);
                    this.exceptionFailure(response, (Exception)((Object)e));
                    return;
                }
            } else {
                if ("/private".equals(path)) {
                    response.sendRedirect("/#/signin");
                    return;
                }
                if (!AUTH_FILTER_LIST.contains(path)) {
                    this.log.error("please login again! the url is:" + path);
                    AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((ErrorCode)ErrorCode.E9999998), (String[])new String[0]);
                    return;
                }
            }
        }
        chain.doFilter(req, resp);
        TimeProfileTool.release();
    }

    private void accountStatusAuth(long mediaId) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByIdNotNull(Long.valueOf(mediaId));
        this.doCheckAudit(mediaId, accountDto.getCheckStatus());
        this.doCheckFreeze(mediaId, accountDto.getFreezeStatus());
    }

    private void doCheckFreeze(long mediaId, Integer freezeStatus) throws TuiaMediaException {
        if (1 == freezeStatus) {
            this.logger.error("the account is freeze, the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102004);
        }
        if (0 != freezeStatus) {
            this.logger.error("the account freeze status is illegal,  the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102005);
        }
    }

    private void doCheckAudit(long mediaId, Integer auditStatus) throws TuiaMediaException {
        if (0 == auditStatus) {
            this.logger.error("user account in review status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102006);
        }
        if (2 == auditStatus) {
            this.logger.error("user account in refuse status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102007);
        }
        if (1 != auditStatus) {
            this.logger.error("the account status is illegal, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102008);
        }
    }

    public void exceptionFailure(HttpServletResponse response, Exception e) {
        if (e instanceof TuiaMediaException) {
            AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((String)((TuiaMediaException)((Object)e)).getResultCode(), (String)((TuiaMediaException)((Object)e)).getResultMessage()), (String[])new String[0]);
        } else {
            this.log.error("\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
            AjaxUtils.renderJson((HttpServletResponse)response, (Object)ResultUtil.fail((ErrorCode)ErrorCode.E9999999), (String[])new String[0]);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig fc) throws ServletException {
        AUTH_FILTER_LIST.add("/");
        AUTH_FILTER_LIST.add("/private");
        AUTH_FILTER_LIST.add("/index.html");
        AUTH_FILTER_LIST.add("/favicon.ico");
        AUTH_FILTER_LIST.add("/#/signin");
        AUTH_FILTER_LIST.add("/private#/404");
        AUTH_FILTER_LIST.add("/__webpack_hmr");
        AUTH_FILTER_LIST.add("/swagger-ui.html");
        AUTH_FILTER_LIST.add("/images/favicon-16x16.png");
        AUTH_FILTER_LIST.add("/swagger-resources");
        AUTH_FILTER_LIST.add("/v2/api-docs");
        AUTH_FILTER_LIST.add("/images/favicon-32x32.png");
        AUTH_FILTER_LIST.add("/images/favicon-16x16.png");
        AUTH_FILTER_LIST.add("/configuration/security");
        AUTH_FILTER_LIST.add("/configuration/ui");
        AUTH_FILTER_LIST.add("/upload/index");
        AUTH_FILTER_LIST.add("/account/resetPasswd/redirect");
        AUTH_FILTER_LIST.add("/account/sendResetPasswdEmail");
        AUTH_FILTER_LIST.add("/account/resetPasswd");
        AUTH_FILTER_LIST.add("/account/isExists");
        AUTH_FILTER_LIST.add("/account/isExistPhone");
        AUTH_FILTER_LIST.add("/account/register");
        AUTH_FILTER_LIST.add("/account/login");
        AUTH_FILTER_LIST.add("/account/verifyEmail");
        AUTH_FILTER_LIST.add("/account/repeatVerifyEmail");
        AUTH_FILTER_LIST.add("/account/updateAuditData");
        AUTH_FILTER_LIST.add("/account/getUncheckAccount");
        AUTH_FILTER_LIST.add("/account/sendResetPdEmail");
        AUTH_FILTER_LIST.add("/account/verifyResetPdCode");
        AUTH_FILTER_LIST.add("/account/resetPassword");
        AUTH_FILTER_LIST.add("/account/logout");
        AUTH_FILTER_LIST.add("/sms/send");
        AUTH_FILTER_LIST.add("/sms/verify");
    }
}

