/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;

@Component
@Order(value=-2147483648)
public class OperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OperationModelsProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public OperationModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromReturnType(context);
        this.collectParameters(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void collectFromReturnType(RequestMappingContext context) {
        ResolvedType modelType = HandlerMethodReturnTypes.handlerReturnType(this.typeResolver, context.getHandlerMethod());
        modelType = context.alternateFor(modelType);
        LOG.debug("Adding return parameter of type {}", ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).or((Object)"<null>"));
        context.operationModelsBuilder().addReturn((Type)modelType);
    }

    private void collectParameters(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        Method method = handlerMethod.getMethod();
        LOG.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        HandlerMethodResolver handlerMethodResolver = new HandlerMethodResolver(this.typeResolver);
        List<ResolvedMethodParameter> parameterTypes = handlerMethodResolver.methodParameters(handlerMethod);
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] pAnnotations;
            for (Annotation annotation : pAnnotations = annotations[i]) {
                if (!(annotation instanceof RequestBody) && !(annotation instanceof RequestPart)) continue;
                ResolvedMethodParameter pType = parameterTypes.get(i);
                ResolvedType modelType = context.alternateFor(pType.getResolvedParameterType());
                LOG.debug("Adding input parameter of type {}", ResolvedTypes.resolvedTypeSignature((ResolvedType)modelType).or((Object)"<null>"));
                context.operationModelsBuilder().addInputParam((Type)modelType);
            }
        }
        LOG.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
    }
}

