/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperService;
import cn.com.duiba.tuia.media.api.dto.AccountDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateAccountCheckStatus;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateAccountFreezeStatus;
import cn.com.duiba.tuia.media.bo.AccountBackendBO;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.BlowfishUtils;
import cn.com.duiba.tuia.media.common.utils.MessageDigestUtils;
import cn.com.duiba.tuia.media.domain.AccountBankDto;
import cn.com.duiba.tuia.media.domain.AccountCheckRecordDto;
import cn.com.duiba.tuia.media.model.Email;
import cn.com.duiba.tuia.media.model.req.ReqRegister;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAccountBank;
import cn.com.duiba.tuia.media.model.req.ReqUpdateAuditData;
import cn.com.duiba.tuia.media.model.rsp.AccountInfoRsp;
import cn.com.duiba.tuia.media.model.rsp.RegisterRsp;
import cn.com.duiba.tuia.media.service.AccountBankService;
import cn.com.duiba.tuia.media.service.AccountCheckRecordService;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.EmailService;
import cn.com.duiba.tuia.media.service.SmsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.redis.RedisClient;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AccountBackendBOImpl
implements AccountBackendBO {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${media.login.encrypt.key}")
    private String loginEncryptKey;
    private ExecutorService executorService = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newFixedThreadPool(3));
    @Autowired
    private AccountService accountService;
    @Autowired
    private AccountBankService accountBankService;
    @Autowired
    private EmailService emailService;
    @Autowired
    protected RedisClient redisClient;
    @Autowired
    private AccountCheckRecordService accountCheckRecordService;
    @Autowired
    private RemoteDeveloperService remoteDeveloperService;
    @Value(value="${media.email.verify.key}")
    private String emailVerifyKey;
    @Autowired
    private SmsService smsService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public RegisterRsp register(final ReqRegister req) throws TuiaMediaException {
        boolean flag;
        final AccountDto accountDto = new AccountDto();
        if (this.accountService.isEmailExists(req.getEmail())) {
            this.logger.error("the account is exist, the email=[{}]", (Object)req.getEmail());
            throw new TuiaMediaException(ErrorCode.E0102011);
        }
        if (this.accountService.isPhoneExists(req.getLinkPhone()) != null) {
            this.logger.error("the phone is exist");
            throw new TuiaMediaException(ErrorCode.E0102021);
        }
        if (this.smsService.verify(req.getType(), req.getLinkPhone(), req.getCode()).booleanValue() && !(flag = ((Boolean)this.transactionTemplate.execute(new TransactionCallback(){

            public final Object doInTransaction(TransactionStatus status) {
                return AccountBackendBOImpl.this.doRegister(req, accountDto, status);
            }
        })).booleanValue())) {
            this.logger.error("add account error");
            throw new TuiaMediaException(ErrorCode.E0102020);
        }
        this.accountService.doSendVerifyEmail(accountDto);
        RegisterRsp rsp = new RegisterRsp();
        rsp.setcName(accountDto.getLinkman());
        rsp.setEmail(accountDto.getEmail());
        rsp.setMediaId(accountDto.getMediaId());
        return rsp;
    }

    private boolean doRegister(ReqRegister req, AccountDto accountDto, TransactionStatus status) {
        try {
            boolean flag = this.doRegisterBaseInfo(req, accountDto);
            if (!flag) {
                this.logger.error("add account error");
                throw new TuiaMediaException(ErrorCode.E0102020);
            }
            AccountBankDto accountBankDto = new AccountBankDto();
            accountBankDto.setMediaId(accountDto.getMediaId());
            accountBankDto.setBankName(req.getBankName());
            accountBankDto.setCardNumber(req.getCardNumber());
            accountBankDto.setProvince(req.getProvince());
            accountBankDto.setCity(req.getCity());
            accountBankDto.setBranchName(req.getBranchName());
            this.accountBankService.insertAccountBank(accountBankDto);
            return true;
        }
        catch (Exception e) {
            this.logger.error("AccountBackendBOImpl.register have error the msg=[{}]", (Throwable)e);
            status.setRollbackOnly();
            return false;
        }
    }

    private boolean doRegisterBaseInfo(ReqRegister req, AccountDto accountDto) throws TuiaMediaException {
        Long mediaId;
        CreateDeveloperParams params = new CreateDeveloperParams();
        params.setEmail(req.getEmail());
        params.setCompany(req.getCompanyName());
        params.setName(req.getLinkman());
        params.setPassword(req.getPassword());
        params.setPhone(req.getLinkPhone());
        DubboResult mediaIdResult = this.remoteDeveloperService.createDeveloper(params, Boolean.valueOf(false));
        if (!mediaIdResult.isSuccess()) {
            this.logger.error("the developer account is exist", (Object)mediaIdResult.getMsg());
            DubboResult developerDtoResult = this.remoteDeveloperService.findDeveloperByEmail(req.getEmail());
            if (!developerDtoResult.isSuccess() || developerDtoResult.getResult() == null) {
                this.logger.error("can not get developer account", (Object)developerDtoResult.getMsg());
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            mediaId = ((DeveloperDto)developerDtoResult.getResult()).getId();
        } else {
            if (mediaIdResult.getResult() == null) {
                this.logger.error("mediaId is null");
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            mediaId = (Long)mediaIdResult.getResult();
        }
        String srePassword = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.sha((String)req.getPassword()), (String)this.loginEncryptKey);
        accountDto.setMediaId(mediaId);
        accountDto.setPassword(srePassword);
        accountDto.setEmail(req.getEmail());
        accountDto.setBusinessLicenseId(req.getBusinessLicenseId());
        accountDto.setBusinessLicenseName(req.getBusinessLicenseName());
        accountDto.setBusinessLicenseUrl(req.getBusinessLicenseUrl());
        accountDto.setCompanyName(req.getCompanyName());
        accountDto.setLinkman(req.getLinkman());
        accountDto.setLinkPhone(req.getLinkPhone());
        return this.accountService.insertAccountBase(accountDto);
    }

    @Override
    public Long login(String email, String password) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByEmail(email);
        this.accountService.accountDtoIsNull(accountDto);
        String srePassword = BlowfishUtils.encryptBlowfish((String)MessageDigestUtils.sha((String)password), (String)this.loginEncryptKey);
        if (!StringUtils.equals((String)srePassword, (String)accountDto.getPassword())) {
            this.logger.error("the password is error, email =[{}]", (Object)password);
            throw new TuiaMediaException(ErrorCode.E0102002);
        }
        Long mediaId = accountDto.getMediaId();
        this.emailStatusAuth(accountDto.getEmailStatus());
        this.accountStatusAuth(mediaId, accountDto.getCheckStatus(), accountDto.getFreezeStatus());
        return accountDto.getMediaId();
    }

    private void emailStatusAuth(Integer eamilStatus) throws TuiaMediaException {
        if (0 == eamilStatus) {
            this.logger.error("the eamil not audit, the email status=[{}]" + eamilStatus);
            throw new TuiaMediaException(ErrorCode.E0102019);
        }
        if (1 != eamilStatus) {
            this.logger.error("the eamil status is illegal, the email status=[{}]", (Object)eamilStatus);
            throw new TuiaMediaException(ErrorCode.E0102022);
        }
    }

    private void accountStatusAuth(long getMediaId, Integer auditStatus, Integer freezeStatus) throws TuiaMediaException {
        this.doCheckAudit(getMediaId, auditStatus);
        this.doCheckFreeze(getMediaId, freezeStatus);
    }

    private void doCheckFreeze(long mediaId, Integer freezeStatus) throws TuiaMediaException {
        if (1 == freezeStatus) {
            AccountCheckRecordDto accountCheckRecordDto = this.accountCheckRecordService.selectLatelyCheckRecord(mediaId, 3);
            if (accountCheckRecordDto == null) {
                this.logger.error(" the getAccountCheckRecord is null, the accountId=[{}]", (Object)mediaId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            this.logger.error("the account is freeze, the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102004.getErrorCode(), "\u8d26\u53f7\u88ab\u51bb\u7ed3\uff0c\u56e0\u4e3a\uff1a" + accountCheckRecordDto.getReason());
        }
        if (0 != freezeStatus) {
            this.logger.error("the account freeze status is illegal,  the freeze status=[{}]", (Object)freezeStatus);
            throw new TuiaMediaException(ErrorCode.E0102005);
        }
    }

    private void doCheckAudit(long mediaId, Integer auditStatus) throws TuiaMediaException {
        if (0 == auditStatus) {
            this.logger.error("user account in review status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102006);
        }
        if (2 == auditStatus) {
            AccountCheckRecordDto accountCheckRecordDto = this.accountCheckRecordService.selectLatelyCheckRecord(mediaId, 2);
            if (accountCheckRecordDto == null) {
                this.logger.error(" the getAccountCheckRecord is null, the accountId=[{}]", (Object)mediaId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            this.logger.error("user account in refuse status, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102007.getErrorCode(), "\u8d26\u53f7\u88ab\u5ba1\u6838\u62d2\u7edd\uff0c\u56e0\u4e3a\uff1a" + accountCheckRecordDto.getReason());
        }
        if (1 != auditStatus) {
            this.logger.error("the account status is illegal, the audit status=[{}]", (Object)auditStatus);
            throw new TuiaMediaException(ErrorCode.E0102008);
        }
    }

    @Override
    public AccountInfoRsp getAccountInfo(Long mediaId) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByMediaId(mediaId);
        this.accountService.accountDtoIsNull(accountDto);
        AccountInfoRsp accountInfoRsp = new AccountInfoRsp();
        this.doAccountBaseInfo(accountDto, accountInfoRsp);
        AccountBankDto accountBankDto = this.accountBankService.selectByMediaId(mediaId);
        if (accountBankDto == null) {
            this.logger.error("account not exist, the media=[{}]", (Object)mediaId);
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
        this.doAccountBankInfo(accountInfoRsp, accountBankDto);
        return accountInfoRsp;
    }

    @Override
    public AccountInfoRsp getUncheckAccountInfo(String email) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByEmail(email);
        this.accountService.accountDtoIsNull(accountDto);
        AccountInfoRsp accountInfoRsp = new AccountInfoRsp();
        this.doAccountBaseInfo(accountDto, accountInfoRsp);
        AccountBankDto accountBankDto = this.accountBankService.selectByMediaId(accountDto.getMediaId());
        if (accountBankDto == null) {
            this.logger.error("account not exist, the media=[{}]", (Object)accountDto.getMediaId());
            throw new TuiaMediaException(ErrorCode.E0102001);
        }
        this.doAccountBankInfo(accountInfoRsp, accountBankDto);
        return accountInfoRsp;
    }

    private void doAccountBankInfo(AccountInfoRsp accountInfoRsp, AccountBankDto accountBankDto) {
        accountInfoRsp.setCardNumber(accountBankDto.getCardNumber());
        accountInfoRsp.setBankName(accountBankDto.getBankName());
        accountInfoRsp.setProvince(accountBankDto.getProvince());
        accountInfoRsp.setCity(accountBankDto.getCity());
        accountInfoRsp.setBranchName(accountBankDto.getBranchName());
    }

    private void doAccountBaseInfo(AccountDto accountDto, AccountInfoRsp accountInfoRsp) {
        accountInfoRsp.setMediaId(accountDto.getMediaId());
        accountInfoRsp.setCompanyName(accountDto.getCompanyName());
        accountInfoRsp.setBusinessLicenseId(accountDto.getBusinessLicenseId());
        accountInfoRsp.setBusinessLicenseName(accountDto.getBusinessLicenseName());
        accountInfoRsp.setBusinessLicenseUrl(accountDto.getBusinessLicenseUrl());
        accountInfoRsp.setEmail(accountDto.getEmail());
        accountInfoRsp.setLinkman(accountDto.getLinkman());
        accountInfoRsp.setLinkPhone(accountDto.getLinkPhone());
    }

    @Override
    public boolean updateAuditData(ReqUpdateAuditData accountInfo) throws TuiaMediaException {
        if (this.smsService.verify(accountInfo.getType(), accountInfo.getLinkPhone(), accountInfo.getCode()).booleanValue()) {
            AccountDto currentData = this.accountService.selectByMediaId(accountInfo.getMediaId());
            if (2 != currentData.getCheckStatus()) {
                throw new TuiaMediaException(ErrorCode.E0102015);
            }
            AccountDto baseReq = new AccountDto();
            baseReq.setMediaId(accountInfo.getMediaId());
            baseReq.setBusinessLicenseId(accountInfo.getBusinessLicenseId());
            baseReq.setBusinessLicenseName(accountInfo.getBusinessLicenseName());
            baseReq.setBusinessLicenseUrl(accountInfo.getBusinessLicenseUrl());
            baseReq.setCompanyName(accountInfo.getCompanyName());
            baseReq.setLinkman(accountInfo.getLinkman());
            baseReq.setLinkPhone(accountInfo.getLinkPhone());
            boolean flag = this.accountService.updateAuditData(baseReq);
            if (flag) {
                ReqUpdateAccountBank bankReq = new ReqUpdateAccountBank();
                bankReq.setMediaId(accountInfo.getMediaId());
                bankReq.setCardNumber(accountInfo.getCardNumber());
                bankReq.setBankName(accountInfo.getBankName());
                bankReq.setProvince(accountInfo.getProvince());
                bankReq.setCity(accountInfo.getCity());
                bankReq.setBranchName(accountInfo.getBranchName());
                this.accountBankService.updateAccountBank(bankReq);
            }
        }
        return true;
    }

    @Override
    public boolean updateCheckStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException {
        boolean flag;
        AccountDto accountDto = this.canUpdateCheckStatus(mediaId);
        int status = -1;
        String checkTypeMessage = "\u5ba1\u6838\u901a\u8fc7";
        if (ReqUpdateAccountCheckStatus.PARAM_CHECK_PASS.intValue() == checkType.intValue()) {
            status = 1;
        }
        if (ReqUpdateAccountCheckStatus.PARAM_CHECK_REFUSE.intValue() == checkType.intValue()) {
            checkTypeMessage = "\u5ba1\u6838\u62d2\u7edd";
            status = 2;
        }
        if (flag = this.accountService.updateCheckStatus(mediaId, status)) {
            AccountCheckRecordDto checkRecord = new AccountCheckRecordDto();
            checkRecord.setMediaId(mediaId);
            checkRecord.setCheckType(checkType);
            checkRecord.setReason(reason);
            checkRecord.setGmtCreate(checkRecord.getGmtCreate());
            checkRecord.setGmtModified(checkRecord.getGmtModified());
            this.accountCheckRecordService.insertCheckRecord(checkRecord);
            this.doSendEmail(checkTypeMessage, accountDto);
            return true;
        }
        return false;
    }

    private AccountDto canUpdateCheckStatus(Long mediaId) throws TuiaMediaException {
        AccountDto accountDto = this.accountService.selectByMediaId(mediaId);
        if (this.isChecked(accountDto)) {
            this.logger.error("the media is checked ,mediaId = [{}]", (Object)mediaId);
            throw new TuiaMediaException(ErrorCode.E0304007);
        }
        return accountDto;
    }

    private boolean isChecked(AccountDto accountDto) {
        return 1 == accountDto.getCheckStatus() || 2 == accountDto.getCheckStatus();
    }

    @Override
    public boolean updateFreezeStatus(Long mediaId, Integer checkType, String reason) throws TuiaMediaException {
        boolean flag;
        int status = -1;
        String checkTypeMessage = "\u89e3\u51bb";
        if (ReqUpdateAccountFreezeStatus.PARAM_UNFREEZE.intValue() == checkType.intValue()) {
            status = 0;
        }
        if (ReqUpdateAccountFreezeStatus.PARAM_FREEZE.intValue() == checkType.intValue()) {
            checkTypeMessage = "\u51bb\u7ed3";
            status = 1;
        }
        if (flag = this.accountService.updateFreezeStatus(mediaId, status)) {
            AccountCheckRecordDto checkRecord = new AccountCheckRecordDto();
            checkRecord.setMediaId(mediaId);
            checkRecord.setCheckType(checkType);
            checkRecord.setReason(reason);
            checkRecord.setGmtCreate(checkRecord.getGmtCreate());
            checkRecord.setGmtModified(checkRecord.getGmtModified());
            this.accountCheckRecordService.insertCheckRecord(checkRecord);
            AccountDto mediaDto = this.accountService.selectByMediaId(mediaId);
            if (mediaDto == null || mediaDto.getEmail() == null) {
                this.logger.error("the media is not exist, the mediaId=[{}]", (Object)mediaId);
                throw new TuiaMediaException(ErrorCode.E0102001);
            }
            this.doSendEmail(checkTypeMessage, mediaDto);
            return true;
        }
        return false;
    }

    private void doSendEmail(String checkTypeMessage, AccountDto accountDto) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("linkman", accountDto.getLinkman());
        model.put("email", accountDto.getEmail());
        model.put("checkTypeMessage", checkTypeMessage);
        final Email email = new Email();
        email.setTo(accountDto.getEmail());
        email.setTemplateLocation("/templates/mail/checkStatus.vm");
        email.setSubject("\u8d26\u53f7\u72b6\u6001\u53d8\u5316\u901a\u77e5");
        email.setModel(model);
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                AccountBackendBOImpl.this.emailService.sendWithTemplate(email);
            }
        });
    }
}

