/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.tuia.media.api.dto.DataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotLineStatisticsDto;
import cn.com.duiba.tuia.media.bo.SlotLineStatisticsBO;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.service.SlotLineStatisticsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotLineStatisticsBOImpl
implements SlotLineStatisticsBO {
    @Autowired
    SlotLineStatisticsService slotLineStatisticsService;
    @Autowired
    SlotDAO slotDao;
    @Autowired
    MediaAppDao mediaAppDao;

    @Override
    public PageResultDto<RspMediaAppDataStatisticsDto> getMediaAppStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        int totalNum = this.slotLineStatisticsService.getMediaAppDataAmount(param);
        List<RspMediaAppDataStatisticsDto> rspMediaAppList = null;
        if (totalNum > 0 && totalNum >= param.getRowStart()) {
            param.setPageSize(Integer.valueOf(50));
            param.setRowStart(param.getPageSize() * (param.getCurrentPage() - 1));
            List<MediaAppStatisticsDto> mediaAppList = this.slotLineStatisticsService.getMediaAppStatisticsData(param);
            ArrayList<Long> mediaAppIds = new ArrayList<Long>(mediaAppList.size());
            for (MediaAppStatisticsDto mediaAppDto : mediaAppList) {
                mediaAppIds.add(mediaAppDto.getAppId());
            }
            Map<Long, String> mediaAppMap = this.getMediaAppMapByIds(mediaAppIds);
            rspMediaAppList = this.rspMediaAppList(mediaAppList, mediaAppMap);
        }
        return new PageResultDto(totalNum, rspMediaAppList, param.getPageSize().intValue());
    }

    @Override
    public PageResultDto<RspSlotDataStatisticsDto> getSlotStatisticsData(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        int totalNum = this.slotLineStatisticsService.getSlotDataAmount(param);
        List<RspSlotDataStatisticsDto> rspSlotList = null;
        if (totalNum > 0 && totalNum >= param.getRowStart()) {
            param.setPageSize(Integer.valueOf(50));
            param.setRowStart(param.getPageSize() * (param.getCurrentPage() - 1));
            List<SlotStatisticsDto> slotList = this.slotLineStatisticsService.getSlotStatisticsData(param);
            ArrayList<Long> soltIds = new ArrayList<Long>(slotList.size());
            for (SlotStatisticsDto slotDto : slotList) {
                soltIds.add(slotDto.getSlotId());
            }
            Map<Long, String> soltMap = this.getSoltMapByIds(soltIds);
            rspSlotList = this.rspSlotList(slotList, soltMap);
        }
        return new PageResultDto(totalNum, rspSlotList, param.getPageSize().intValue());
    }

    @Override
    public RspSlotLineStatisticsDto selectStatisticsDataByDate(ReqSlotLineStatisticsByPageDto param) throws TuiaMediaException {
        param.setOrder("asc");
        param.setSort("cur_date");
        List<DataStatisticsDto> dataStatisticsList = this.slotLineStatisticsService.getStatisticsDataByDate(param);
        return this.dataFormat(dataStatisticsList);
    }

    private Map<Long, String> getSoltMapByIds(List<Long> soltIds) throws TuiaMediaException {
        HashMap<Long, String> slotMap = null;
        if (CollectionUtils.isNotEmpty(soltIds)) {
            slotMap = new HashMap<Long, String>(soltIds.size());
            List<IdAndName> list = this.slotDao.selectAppIdAndName(soltIds);
            for (IdAndName slotVO : list) {
                slotMap.put(slotVO.getId(), slotVO.getName());
            }
        }
        return slotMap;
    }

    private Map<Long, String> getMediaAppMapByIds(List<Long> mediaAppIds) throws TuiaMediaException {
        HashMap<Long, String> mediaAppMap = null;
        if (CollectionUtils.isNotEmpty(mediaAppIds)) {
            mediaAppMap = new HashMap<Long, String>(mediaAppIds.size());
            List<IdAndName> list = this.mediaAppDao.selectAppIdAndName(mediaAppIds);
            for (IdAndName mediaAppVO : list) {
                mediaAppMap.put(mediaAppVO.getId(), mediaAppVO.getName());
            }
        }
        return mediaAppMap;
    }

    private List<RspSlotDataStatisticsDto> rspSlotList(List<SlotStatisticsDto> slotList, Map<Long, String> slotMap) {
        ArrayList<RspSlotDataStatisticsDto> rspSoltList = new ArrayList<RspSlotDataStatisticsDto>(slotList.size());
        for (SlotStatisticsDto dto : slotList) {
            RspSlotDataStatisticsDto rspDto = new RspSlotDataStatisticsDto();
            rspDto.setSlotId(dto.getSlotId());
            rspDto.setSlotType(dto.getSlotType());
            rspDto.setClickCount(dto.getClickCount());
            rspDto.setConsumeTotal(dto.getConsumeTotal());
            rspDto.setExposureCount(dto.getExposureCount());
            rspDto.setSlotName(slotMap.get(dto.getSlotId()));
            this.calculateSlotStatisticsData(rspDto);
            rspSoltList.add(rspDto);
        }
        return rspSoltList;
    }

    private List<RspMediaAppDataStatisticsDto> rspMediaAppList(List<MediaAppStatisticsDto> mediaAppList, Map<Long, String> mediaAppMap) {
        ArrayList<RspMediaAppDataStatisticsDto> rspSoltList = new ArrayList<RspMediaAppDataStatisticsDto>(mediaAppList.size());
        for (MediaAppStatisticsDto dto : mediaAppList) {
            RspMediaAppDataStatisticsDto rspDto = new RspMediaAppDataStatisticsDto();
            rspDto.setAppId(dto.getAppId());
            rspDto.setAppName(mediaAppMap.get(dto.getAppId()));
            rspDto.setClickCount(dto.getClickCount());
            rspDto.setConsumeTotal(dto.getConsumeTotal());
            rspDto.setExposureCount(dto.getExposureCount());
            rspDto.setPlatform(dto.getPlatform());
            this.calculateMediaAppStatisticsData(rspDto);
            rspSoltList.add(rspDto);
        }
        return rspSoltList;
    }

    private void calculateMediaAppStatisticsData(RspMediaAppDataStatisticsDto data) {
        if (data.getExposureCount() != null) {
            data.seteCpm(DataTool.calculateEcpm((Long)data.getConsumeTotal(), (Long)data.getExposureCount()));
        }
        data.setCpc(DataTool.calculateAveragePrice((Long)data.getConsumeTotal(), (Long)data.getClickCount()));
    }

    private void calculateSlotStatisticsData(RspSlotDataStatisticsDto data) {
        if (data.getExposureCount() != null) {
            data.seteCpm(DataTool.calculateEcpm((Long)data.getConsumeTotal(), (Long)data.getExposureCount()));
        }
        data.setCpc(DataTool.calculateAveragePrice((Long)data.getConsumeTotal(), (Long)data.getClickCount()));
    }

    private RspSlotLineStatisticsDto dataFormat(List<DataStatisticsDto> dataList) {
        RspSlotLineStatisticsDto rspDto = new RspSlotLineStatisticsDto();
        if (CollectionUtils.isNotEmpty(dataList)) {
            ArrayList<String> curDateList = new ArrayList<String>(dataList.size());
            ArrayList<Long> exposureCountList = new ArrayList<Long>(dataList.size());
            ArrayList<Long> clickCountList = new ArrayList<Long>(dataList.size());
            ArrayList<Long> consumeTotalList = new ArrayList<Long>(dataList.size());
            ArrayList<Long> ecpmList = new ArrayList<Long>(dataList.size());
            ArrayList<Long> clickRateList = new ArrayList<Long>(dataList.size());
            for (DataStatisticsDto dto : dataList) {
                curDateList.add(dto.getCurDate());
                clickCountList.add(dto.getClickCount());
                exposureCountList.add(dto.getExposureCount());
                ecpmList.add(this.calculateEcpmData(dto));
                consumeTotalList.add(dto.getConsumeTotal());
                clickRateList.add(this.calculateClickRateData(dto));
            }
            rspDto.setClickCount(clickCountList);
            rspDto.setConsumeTotal(consumeTotalList);
            rspDto.setCurDate(curDateList);
            rspDto.seteCpm(ecpmList);
            rspDto.setExposureCount(exposureCountList);
            rspDto.setClickRate(clickRateList);
        }
        return rspDto;
    }

    private Long calculateEcpmData(DataStatisticsDto data) {
        return DataTool.calculateEcpm((Long)data.getConsumeTotal(), (Long)data.getExposureCount());
    }

    private Long calculateClickRateData(DataStatisticsDto data) {
        return DataTool.calculateClickRade((Long)data.getClickCount(), (Long)data.getExposureCount());
    }
}

