/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.AssocCommandAware;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.MapReturnValueAware;
import net.rubyeye.xmemcached.command.MergeCommandsAware;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextGetCommand
extends Command
implements MergeCommandsAware,
AssocCommandAware,
MapReturnValueAware {
    protected Map<String, CachedData> returnValues;
    private String currentReturnKey;
    private int offset;
    private List<Command> assocCommands;
    private Map<Object, Command> mergeCommands;
    private ParseStatus parseStatus = ParseStatus.NULL;
    protected boolean wasFirst = true;

    @Override
    public final Map<Object, Command> getMergeCommands() {
        return this.mergeCommands;
    }

    @Override
    public final void setMergeCommands(Map<Object, Command> mergeCommands) {
        this.mergeCommands = mergeCommands;
    }

    @Override
    public final List<Command> getAssocCommands() {
        return this.assocCommands;
    }

    @Override
    public final void setAssocCommands(List<Command> assocCommands) {
        this.assocCommands = assocCommands;
    }

    public TextGetCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch) {
        super(key, keyBytes, cmdType, latch);
        this.returnValues = new HashMap<String, CachedData>(32);
    }

    public ParseStatus getParseStatus() {
        return this.parseStatus;
    }

    public void setParseStatus(ParseStatus parseStatus) {
        this.parseStatus = parseStatus;
    }

    @Override
    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        block12: while (true) {
            if (buffer == null || !buffer.hasRemaining()) {
                return false;
            }
            switch (this.parseStatus) {
                case NULL: {
                    if (buffer.remaining() < 2) {
                        return false;
                    }
                    byte first = buffer.get(buffer.position());
                    byte second = buffer.get(buffer.position() + 1);
                    if (first == 69 && second == 78) {
                        this.parseStatus = ParseStatus.END;
                        this.dispatch();
                        this.currentReturnKey = null;
                        continue block12;
                    }
                    if (first == 86) {
                        this.parseStatus = ParseStatus.VALUE;
                        this.wasFirst = false;
                        continue block12;
                    }
                    return this.decodeError(session, buffer);
                }
                case END: {
                    return ByteUtils.stepBuffer(buffer, 5);
                }
                case VALUE: {
                    if (ByteUtils.stepBuffer(buffer, 6)) {
                        this.parseStatus = ParseStatus.KEY;
                        continue block12;
                    }
                    return false;
                }
                case KEY: {
                    String item = this.getItem(buffer, ' ', new char[0]);
                    if (item == null) {
                        return false;
                    }
                    this.currentReturnKey = item;
                    this.returnValues.put(this.currentReturnKey, new CachedData());
                    this.parseStatus = ParseStatus.FLAG;
                    continue block12;
                }
                case FLAG: {
                    String item = this.getItem(buffer, ' ', new char[0]);
                    if (item == null) {
                        return false;
                    }
                    CachedData cachedData = this.returnValues.get(this.currentReturnKey);
                    cachedData.setFlag(Integer.parseInt(item));
                    this.parseStatus = ParseStatus.DATA_LEN;
                    continue block12;
                }
                case DATA_LEN: {
                    String item = this.getItem(buffer, '\r', ' ');
                    if (item == null) {
                        return false;
                    }
                    CachedData cachedData = this.returnValues.get(this.currentReturnKey);
                    cachedData.setCapacity(Integer.parseInt(item));
                    assert (cachedData.getCapacity() >= 0);
                    cachedData.setData(new byte[cachedData.getCapacity()]);
                    this.parseStatus = ParseStatus.DATA_LEN_DONE;
                    continue block12;
                }
                case DATA_LEN_DONE: {
                    if (buffer.remaining() < 1) {
                        return false;
                    }
                    byte first = buffer.get(buffer.position());
                    if (first == 10) {
                        buffer.position(buffer.position() + 1);
                        this.parseStatus = ParseStatus.DATA;
                        continue block12;
                    }
                    this.parseStatus = ParseStatus.CAS;
                    continue block12;
                }
                case CAS: {
                    String item = this.getItem(buffer, '\r', new char[0]);
                    if (item == null) {
                        return false;
                    }
                    CachedData cachedData = this.returnValues.get(this.currentReturnKey);
                    cachedData.setCas(Long.parseLong(item));
                    this.parseStatus = ParseStatus.CAS_DONE;
                    continue block12;
                }
                case CAS_DONE: {
                    if (buffer.remaining() < 1) {
                        return false;
                    }
                    this.parseStatus = ParseStatus.DATA;
                    buffer.position(buffer.position() + 1);
                    continue block12;
                }
                case DATA: {
                    TextGetCommand command;
                    CachedData value = this.returnValues.get(this.currentReturnKey);
                    int remaining = buffer.remaining();
                    int remainingCapacity = value.remainingCapacity();
                    assert (remainingCapacity >= 0);
                    if (remaining < remainingCapacity + 2) {
                        int length = remaining > remainingCapacity ? remainingCapacity : remaining;
                        value.fillData(buffer, length);
                        return false;
                    }
                    if (remainingCapacity > 0) {
                        value.fillData(buffer, remainingCapacity);
                    }
                    assert (value.remainingCapacity() == 0);
                    buffer.position(buffer.position() + ByteUtils.SPLIT.remaining());
                    Map<Object, Command> mergetCommands = this.getMergeCommands();
                    if (mergetCommands != null && (command = (TextGetCommand)mergetCommands.remove(this.currentReturnKey)) != null) {
                        command.setResult(value);
                        command.countDownLatch();
                        --this.mergeCount;
                        if (command.getAssocCommands() != null) {
                            for (Command assocCommand : command.getAssocCommands()) {
                                assocCommand.setResult(value);
                                assocCommand.countDownLatch();
                                --this.mergeCount;
                            }
                        }
                    }
                    this.currentReturnKey = null;
                    this.parseStatus = ParseStatus.NULL;
                    continue block12;
                }
            }
            break;
        }
        return this.decodeError(session, buffer);
    }

    private String getItem(ByteBuffer buffer, char token, char ... others) {
        int pos;
        int limit = buffer.limit();
        for (pos = buffer.position() + this.offset; pos < limit; ++pos) {
            byte b = buffer.get(pos);
            if (b != token && !this.isIn(b, others)) continue;
            byte[] keyBytes = new byte[pos - buffer.position()];
            buffer.get(keyBytes);
            this.offset = 0;
            assert (pos == buffer.position());
            buffer.position(pos + 1);
            return this.getString(keyBytes);
        }
        this.offset = pos - buffer.position();
        return null;
    }

    private boolean isIn(byte b, char[] others) {
        for (int i = 0; i < others.length; ++i) {
            if (b != others[i]) continue;
            return true;
        }
        return false;
    }

    private String getString(byte[] keyBytes) {
        try {
            return new String(keyBytes, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Map<String, CachedData> getReturnValues() {
        return this.returnValues;
    }

    public final void setReturnValues(Map<String, CachedData> returnValues) {
        this.returnValues = returnValues;
    }

    public abstract void dispatch();

    @Override
    public void encode() {
        byte[] cmdBytes = this.commandType == CommandType.GET_ONE || this.commandType == CommandType.GET_MANY ? Constants.GET : Constants.GETS;
        this.ioBuffer = IoBuffer.allocate(cmdBytes.length + Constants.CRLF.length + 1 + this.keyBytes.length);
        ByteUtils.setArguments(this.ioBuffer, cmdBytes, this.keyBytes);
        this.ioBuffer.flip();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParseStatus {
        NULL,
        VALUE,
        KEY,
        FLAG,
        DATA_LEN,
        DATA_LEN_DONE,
        CAS,
        CAS_DONE,
        DATA,
        END;

    }
}

