/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpFactory;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.utils.ExceptionFactory;
import com.aliyun.oss.common.utils.HttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class DefaultServiceClient
extends ServiceClient {
    private HttpClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = new HttpFactory().createHttpClient(config);
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        assert (request != null && context != null);
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        HttpRequestBase httpRequest = new HttpFactory().createHttpRequest(request, context);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (IOException ex) {
            throw ExceptionFactory.createNetworkException(ex);
        }
        ResponseMessage result = new ResponseMessage();
        result.setUrl(request.getUri());
        if (response.getStatusLine() != null) {
            result.setStatusCode(response.getStatusLine().getStatusCode());
        }
        if (response.getEntity() != null) {
            result.setContent(response.getEntity().getContent());
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            resultHeaders.put(h.getName(), h.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(resultHeaders);
        result.setHeaders(resultHeaders);
        return result;
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException && ((errorCode = ((ClientException)ex).getErrorCode()).equals("ConnectionTimeout") || errorCode.equals("SocketTimeout"))) {
                return true;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

