/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.CollectionUtils;

public abstract class ScanCursor<T>
implements Cursor<T> {
    private CursorState state;
    private long cursorId;
    private Iterator<T> delegate;
    private final ScanOptions scanOptions;
    private long position;

    public ScanCursor() {
        this(ScanOptions.NONE);
    }

    public ScanCursor(ScanOptions options) {
        this(0L, options);
    }

    public ScanCursor(long cursorId) {
        this(cursorId, ScanOptions.NONE);
    }

    public ScanCursor(long cursorId, ScanOptions options) {
        this.scanOptions = options != null ? options : ScanOptions.NONE;
        this.cursorId = cursorId;
        this.state = CursorState.READY;
        this.delegate = Collections.emptyList().iterator();
    }

    private void scan(long cursorId) {
        ScanIteration<T> result = this.doScan(cursorId, this.scanOptions);
        this.processScanResult(result);
    }

    protected abstract ScanIteration<T> doScan(long var1, ScanOptions var3);

    @Override
    public final ScanCursor<T> open() {
        if (!this.isReady()) {
            throw new InvalidDataAccessApiUsageException("Cursor already " + (Object)((Object)this.state) + ". Cannot (re)open it.");
        }
        this.state = CursorState.OPEN;
        this.doOpen(this.cursorId);
        return this;
    }

    protected void doOpen(long cursorId) {
        this.scan(cursorId);
    }

    private void processScanResult(ScanIteration<T> result) {
        if (result == null) {
            this.resetDelegate();
            this.state = CursorState.FINISHED;
            return;
        }
        this.cursorId = result.getCursorId();
        if (this.cursorId == 0L) {
            this.state = CursorState.FINISHED;
        }
        if (!CollectionUtils.isEmpty(result.getItems())) {
            this.delegate = result.iterator();
        } else {
            this.resetDelegate();
        }
    }

    private void resetDelegate() {
        this.delegate = Collections.emptyList().iterator();
    }

    @Override
    public long getCursorId() {
        return this.cursorId;
    }

    @Override
    public boolean hasNext() {
        this.assertCursorIsOpen();
        if (!this.delegate.hasNext() && !CursorState.FINISHED.equals((Object)this.state)) {
            this.scan(this.cursorId);
        }
        if (this.delegate.hasNext()) {
            return true;
        }
        return this.cursorId > 0L;
    }

    private void assertCursorIsOpen() {
        if (this.isReady() || this.isClosed()) {
            throw new InvalidDataAccessApiUsageException("Cannot access closed cursor. Did you forget to call open()?");
        }
    }

    @Override
    public T next() {
        this.assertCursorIsOpen();
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available for cursor " + this.cursorId + ".");
        }
        T next = this.moveNext(this.delegate);
        ++this.position;
        return next;
    }

    protected T moveNext(Iterator<T> source) {
        return source.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try {
            this.doClose();
        }
        finally {
            this.state = CursorState.CLOSED;
        }
    }

    protected void doClose() {
    }

    @Override
    public boolean isClosed() {
        return this.state == CursorState.CLOSED;
    }

    protected final boolean isReady() {
        return this.state == CursorState.READY;
    }

    protected final boolean isOpen() {
        return this.state == CursorState.OPEN;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    static enum CursorState {
        READY,
        OPEN,
        FINISHED,
        CLOSED;

    }
}

