/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.MediaFileAddResponse;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaFileAddRequest
implements TaobaoUploadRequest<MediaFileAddResponse> {
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String bizCode;
    private Long dirId;
    private Long ext;
    private FileItem fileData;
    private String name;
    private Map<String, String> headerMap = new TaobaoHashMap();

    public void setBizCode(String bizCode) {
        this.bizCode = bizCode;
    }

    public String getBizCode() {
        return this.bizCode;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getDirId() {
        return this.dirId;
    }

    public void setExt(Long ext) {
        this.ext = ext;
    }

    public Long getExt() {
        return this.ext;
    }

    public void setFileData(FileItem fileData) {
        this.fileData = fileData;
    }

    public FileItem getFileData() {
        return this.fileData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.media.file.add";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("biz_code", this.bizCode);
        txtParams.put("dir_id", (Object)this.dirId);
        txtParams.put("ext", (Object)this.ext);
        txtParams.put("name", this.name);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Map<String, FileItem> getFileParams() {
        HashMap<String, FileItem> params = new HashMap<String, FileItem>();
        params.put("file_data", this.fileData);
        return params;
    }

    @Override
    public Class<MediaFileAddResponse> getResponseClass() {
        return MediaFileAddResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.bizCode, "bizCode");
        RequestCheckUtils.checkNotEmpty(this.dirId, "dirId");
        RequestCheckUtils.checkMinValue(this.dirId, 0L, "dirId");
        RequestCheckUtils.checkNotEmpty(this.fileData, "fileData");
        RequestCheckUtils.checkNotEmpty(this.name, "name");
        RequestCheckUtils.checkMaxLength(this.name, 50, "name");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

