/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport.grizzly;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.io.Bytes;
import com.alibaba.dubbo.common.io.UnsafeByteArrayInputStream;
import com.alibaba.dubbo.common.io.UnsafeByteArrayOutputStream;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Codec;
import com.alibaba.dubbo.remoting.transport.grizzly.GrizzlyChannel;
import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class GrizzlyCodecAdapter
extends BaseFilter {
    private static final String BUFFER_KEY = GrizzlyCodecAdapter.class.getName() + ".BUFFER";
    private final Codec codec;
    private final URL url;
    private final ChannelHandler handler;
    private final int bufferSize;

    public GrizzlyCodecAdapter(Codec codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleWrite(FilterChainContext context) throws IOException {
        Connection connection = context.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            UnsafeByteArrayOutputStream output = new UnsafeByteArrayOutputStream(1024);
            Object msg = context.getMessage();
            this.codec.encode(channel, output, msg);
            GrizzlyChannel.removeChannelIfDisconnectd(connection);
            byte[] bytes = output.toByteArray();
            Buffer buffer = connection.getTransport().getMemoryManager().allocate(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            buffer.allowBufferDispose(true);
            context.setMessage((Object)buffer);
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnectd(connection);
        }
        return context.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext context) throws IOException {
        Object message = context.getMessage();
        Connection connection = context.getConnection();
        GrizzlyChannel channel = GrizzlyChannel.getOrAddChannel(connection, this.url, this.handler);
        try {
            if (message instanceof Buffer) {
                int limit;
                int offset;
                byte[] bytes;
                Buffer buffer = (Buffer)message;
                int readable = buffer.capacity();
                if (readable == 0) {
                    NextAction nextAction = context.getStopAction();
                    return nextAction;
                }
                Object[] remainder = (Object[])channel.getAttribute(BUFFER_KEY);
                channel.removeAttribute(BUFFER_KEY);
                if (remainder == null) {
                    bytes = new byte[this.bufferSize];
                    offset = 0;
                    limit = 0;
                } else {
                    bytes = (byte[])remainder[0];
                    offset = (Integer)remainder[1];
                    limit = (Integer)remainder[2];
                }
                NextAction nextAction = this.receive(context, channel, buffer, readable, bytes, offset, limit);
                return nextAction;
            }
            if (message instanceof Object[]) {
                Object[] remainder = (Object[])message;
                Buffer buffer = (Buffer)remainder[0];
                int readable = (Integer)remainder[1];
                byte[] bytes = (byte[])remainder[2];
                int offset = (Integer)remainder[3];
                int limit = (Integer)remainder[4];
                NextAction nextAction = this.receive(context, channel, buffer, readable, bytes, offset, limit);
                return nextAction;
            }
            NextAction nextAction = context.getInvokeAction();
            return nextAction;
        }
        finally {
            GrizzlyChannel.removeChannelIfDisconnectd(connection);
        }
    }

    private NextAction receive(FilterChainContext context, Channel channel, Buffer buffer, int readable, byte[] bytes, int offset, int limit) throws IOException {
        Object msg;
        UnsafeByteArrayInputStream input;
        while (true) {
            int read = Math.min(readable, bytes.length - limit);
            buffer.get(bytes, limit, read);
            readable -= read;
            input = new UnsafeByteArrayInputStream(bytes, offset, (limit += read) - offset);
            msg = this.codec.decode(channel, input);
            if (msg != Codec.NEED_MORE_INPUT) break;
            if (readable == 0) {
                channel.setAttribute(BUFFER_KEY, new Object[]{bytes, offset, limit});
                return context.getStopAction();
            }
            if (offset == 0) {
                bytes = Bytes.copyOf(bytes, bytes.length << 1);
                continue;
            }
            int len = limit - offset;
            System.arraycopy(bytes, offset, bytes, 0, len);
            offset = 0;
            limit = len;
        }
        int position = input.position();
        if (position == offset) {
            throw new IOException("Decode without read data.");
        }
        offset = position;
        context.setMessage(msg);
        if (limit - offset > 0 || readable > 0) {
            return context.getInvokeAction((Object)new Object[]{buffer, readable, bytes, offset, limit});
        }
        return context.getInvokeAction();
    }
}

