/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.buffer.SimpleBufferAllocator;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BinaryAppendPrependCommand;
import net.rubyeye.xmemcached.command.binary.BinaryAuthListMechanismsCommand;
import net.rubyeye.xmemcached.command.binary.BinaryAuthStartCommand;
import net.rubyeye.xmemcached.command.binary.BinaryAuthStepCommand;
import net.rubyeye.xmemcached.command.binary.BinaryCASCommand;
import net.rubyeye.xmemcached.command.binary.BinaryDeleteCommand;
import net.rubyeye.xmemcached.command.binary.BinaryFlushAllCommand;
import net.rubyeye.xmemcached.command.binary.BinaryGetAndTouchCommand;
import net.rubyeye.xmemcached.command.binary.BinaryGetCommand;
import net.rubyeye.xmemcached.command.binary.BinaryGetMultiCommand;
import net.rubyeye.xmemcached.command.binary.BinaryIncrDecrCommand;
import net.rubyeye.xmemcached.command.binary.BinaryQuitCommand;
import net.rubyeye.xmemcached.command.binary.BinaryStatsCommand;
import net.rubyeye.xmemcached.command.binary.BinaryStoreCommand;
import net.rubyeye.xmemcached.command.binary.BinaryTouchCommand;
import net.rubyeye.xmemcached.command.binary.BinaryVerbosityCommand;
import net.rubyeye.xmemcached.command.binary.BinaryVersionCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryCommandFactory
implements CommandFactory {
    private BufferAllocator bufferAllocator = new SimpleBufferAllocator();

    @Override
    public void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = bufferAllocator;
    }

    @Override
    public Command createAddCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.ADD, noreply, transcoder);
    }

    @Override
    public Command createAppendCommand(String key, byte[] keyBytes, Object value, boolean noreply, Transcoder transcoder) {
        return new BinaryAppendPrependCommand(key, keyBytes, CommandType.APPEND, new CountDownLatch(1), 0, 0L, value, noreply, transcoder);
    }

    @Override
    public Command createCASCommand(String key, byte[] keyBytes, int exp, Object value, long cas, boolean noreply, Transcoder transcoder) {
        return new BinaryCASCommand(key, keyBytes, CommandType.CAS, new CountDownLatch(1), exp, cas, value, noreply, transcoder);
    }

    @Override
    public Command createDeleteCommand(String key, byte[] keyBytes, int time, long cas, boolean noreply) {
        return new BinaryDeleteCommand(key, keyBytes, cas, CommandType.DELETE, new CountDownLatch(1), noreply);
    }

    @Override
    public Command createFlushAllCommand(CountDownLatch latch, int delay, boolean noreply) {
        return new BinaryFlushAllCommand(latch, delay, noreply);
    }

    @Override
    public Command createGetCommand(String key, byte[] keyBytes, CommandType cmdType, Transcoder transcoder) {
        return new BinaryGetCommand(key, keyBytes, cmdType, new CountDownLatch(1), OpCode.GET, false);
    }

    @Override
    public <T> Command createGetMultiCommand(Collection<String> keys, CountDownLatch latch, CommandType cmdType, Transcoder<T> transcoder) {
        Iterator<String> it = keys.iterator();
        String key = null;
        ArrayList<IoBuffer> bufferList = new ArrayList<IoBuffer>();
        int totalLength = 0;
        while (it.hasNext()) {
            key = it.next();
            if (!it.hasNext()) continue;
            BinaryGetCommand command = new BinaryGetCommand(key, ByteUtils.getBytes(key), cmdType, null, OpCode.GET_KEY_QUIETLY, true);
            ((Command)command).encode();
            totalLength += command.getIoBuffer().remaining();
            bufferList.add(command.getIoBuffer());
        }
        BinaryGetCommand lastCommand = new BinaryGetCommand(key, ByteUtils.getBytes(key), cmdType, new CountDownLatch(1), OpCode.GET_KEY, false);
        ((Command)lastCommand).encode();
        bufferList.add(lastCommand.getIoBuffer());
        IoBuffer mergedBuffer = IoBuffer.allocate(totalLength += lastCommand.getIoBuffer().remaining());
        for (IoBuffer buffer : bufferList) {
            mergedBuffer.put(buffer.buf());
        }
        mergedBuffer.flip();
        BinaryGetMultiCommand resultCommand = new BinaryGetMultiCommand(key, cmdType, latch);
        resultCommand.setIoBuffer(mergedBuffer);
        return resultCommand;
    }

    @Override
    public Command createIncrDecrCommand(String key, byte[] keyBytes, long amount, long initial, int expTime, CommandType cmdType, boolean noreply) {
        return new BinaryIncrDecrCommand(key, keyBytes, amount, initial, expTime, cmdType, noreply);
    }

    @Override
    public Command createPrependCommand(String key, byte[] keyBytes, Object value, boolean noreply, Transcoder transcoder) {
        return new BinaryAppendPrependCommand(key, keyBytes, CommandType.PREPEND, new CountDownLatch(1), 0, 0L, value, noreply, transcoder);
    }

    @Override
    public Command createReplaceCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.REPLACE, noreply, transcoder);
    }

    final Command createStoreCommand(String key, byte[] keyBytes, int exp, Object value, CommandType cmdType, boolean noreply, Transcoder transcoder) {
        return new BinaryStoreCommand(key, keyBytes, cmdType, new CountDownLatch(1), exp, -1L, value, noreply, transcoder);
    }

    @Override
    public Command createSetCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.SET, noreply, transcoder);
    }

    @Override
    public Command createStatsCommand(InetSocketAddress server, CountDownLatch latch, String itemName) {
        return new BinaryStatsCommand(server, latch, itemName);
    }

    @Override
    public Command createVerbosityCommand(CountDownLatch latch, int level, boolean noreply) {
        return new BinaryVerbosityCommand(latch, level, noreply);
    }

    @Override
    public Command createVersionCommand(CountDownLatch latch, InetSocketAddress server) {
        return new BinaryVersionCommand(latch, server);
    }

    @Override
    public Command createAuthListMechanismsCommand(CountDownLatch latch) {
        return new BinaryAuthListMechanismsCommand(latch);
    }

    @Override
    public Command createAuthStartCommand(String mechanism, CountDownLatch latch, byte[] authData) {
        return new BinaryAuthStartCommand(mechanism, ByteUtils.getBytes(mechanism), latch, authData);
    }

    @Override
    public Command createAuthStepCommand(String mechanism, CountDownLatch latch, byte[] authData) {
        return new BinaryAuthStepCommand(mechanism, ByteUtils.getBytes(mechanism), latch, authData);
    }

    @Override
    public Command createGetAndTouchCommand(String key, byte[] keyBytes, CountDownLatch latch, int exp, boolean noreply) {
        return new BinaryGetAndTouchCommand(key, keyBytes, noreply ? CommandType.GATQ : CommandType.GAT, latch, exp, noreply);
    }

    @Override
    public Command createTouchCommand(String key, byte[] keyBytes, CountDownLatch latch, int exp, boolean noreply) {
        return new BinaryTouchCommand(key, keyBytes, CommandType.TOUCH, latch, exp, noreply);
    }

    @Override
    public Command createQuitCommand() {
        return new BinaryQuitCommand();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.Binary;
    }
}

