/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.bo.impl;

import cn.com.duiba.tuia.media.api.dto.MediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotStatisticsDto;
import cn.com.duiba.tuia.media.bo.SlotStatisticsBackendBO;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.DataTool;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.service.MediaAppService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.SlotStatisticsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotStatisticsBackendBOImpl
implements SlotStatisticsBackendBO {
    private static final int PAGE_SIZE_TEN = 10;
    @Autowired
    private SlotStatisticsService slotStatisticsService;
    @Autowired
    private MediaAppService mediaAppService;
    @Autowired
    private SlotService slotService;

    @Override
    public PageResultDto<RspSlotStatisticsDto> getAdsenseData(ReqSlotStatisticsDto req) throws TuiaMediaException {
        String slotName = req.getSlotName();
        List<Long> slotIdsList = null;
        if (StringUtils.isNotBlank((CharSequence)slotName) && CollectionUtils.isEmpty(slotIdsList = this.slotService.selectIdsByName(slotName))) {
            return new PageResultDto(0, null, req.getPageSize().intValue());
        }
        String appName = req.getAppName();
        List<Long> appIdsList = null;
        if (StringUtils.isNotBlank((CharSequence)appName) && CollectionUtils.isEmpty(appIdsList = this.mediaAppService.selectIdsByName(appName))) {
            return new PageResultDto(0, null, req.getPageSize().intValue());
        }
        Integer totalAmount = this.slotStatisticsService.getAdsenseDataAmount(req, slotIdsList, appIdsList);
        ArrayList<RspSlotStatisticsDto> rspDtos = null;
        req.setPageSize(Integer.valueOf(10));
        if (totalAmount > 0 && totalAmount >= req.getRowStart()) {
            req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
            List<SlotStatisticsDto> slotStatisticsDtos = this.slotStatisticsService.getAdsenseDataByPage(req, slotIdsList, appIdsList);
            int size = slotStatisticsDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            ArrayList<Long> slotIds = new ArrayList<Long>(size);
            for (SlotStatisticsDto slotStatisticsDto : slotStatisticsDtos) {
                appIds.add(slotStatisticsDto.getAppId());
                slotIds.add(slotStatisticsDto.getSlotId());
            }
            rspDtos = new ArrayList<RspSlotStatisticsDto>(size);
            Map<Long, String> slotMap = this.getSlotMap(slotIds);
            Map<Long, String> appMap = this.getMediaMap(appIds);
            this.doRsp(slotStatisticsDtos, rspDtos, slotMap, appMap);
        }
        return new PageResultDto(totalAmount.intValue(), rspDtos, req.getPageSize().intValue());
    }

    private void doRsp(List<SlotStatisticsDto> slotStatisticsDtos, List<RspSlotStatisticsDto> rspDtos, Map<Long, String> slotMap, Map<Long, String> appMap) {
        for (SlotStatisticsDto dto : slotStatisticsDtos) {
            RspSlotStatisticsDto rspDto = new RspSlotStatisticsDto();
            rspDto.setSlotId(dto.getSlotId());
            rspDto.setSlotType(dto.getSlotType());
            rspDto.setClickCount(dto.getClickCount());
            rspDto.setConsumeTotal(dto.getConsumeTotal());
            rspDto.setExposureCount(dto.getExposureCount());
            rspDto.setAppName(appMap.get(dto.getAppId()));
            rspDto.setSlotName(slotMap.get(dto.getSlotId()));
            this.calculateStatisticsData(rspDto);
            rspDtos.add(rspDto);
        }
    }

    private Map<Long, String> getMediaMap(List<Long> appIds) throws TuiaMediaException {
        HashMap<Long, String> appMap = new HashMap<Long, String>(1);
        if (CollectionUtils.isNotEmpty(appIds)) {
            List<IdAndName> appIdAndNameList = this.mediaAppService.selectAppIdAndName(appIds);
            for (IdAndName appVO : appIdAndNameList) {
                appMap.put(appVO.getId(), appVO.getName());
            }
        }
        return appMap;
    }

    private Map<Long, String> getSlotMap(List<Long> slotIds) throws TuiaMediaException {
        HashMap<Long, String> slotMap = new HashMap<Long, String>(1);
        if (CollectionUtils.isNotEmpty(slotIds)) {
            List<IdAndName> slotIdAndNameList = this.slotService.selectAppIdAndName(slotIds);
            for (IdAndName slotVO : slotIdAndNameList) {
                slotMap.put(slotVO.getId(), slotVO.getName());
            }
        }
        return slotMap;
    }

    private void calculateStatisticsData(RspSlotStatisticsDto data) {
        if (data.getExposureCount() != null) {
            data.seteCpm(DataTool.calculateEcpm((Long)data.getConsumeTotal(), (Long)data.getExposureCount()));
        }
        data.setCpc(DataTool.calculateAveragePrice((Long)data.getConsumeTotal(), (Long)data.getClickCount()));
    }

    @Override
    public PageResultDto<RspMediaAppStatisticsDto> getMediaData(ReqMediaAppStatisticsDto req) throws TuiaMediaException {
        String appName = req.getAppName();
        List<Long> appIdsByName = null;
        if (appName != null && CollectionUtils.isEmpty(appIdsByName = this.mediaAppService.selectIdsByName(appName))) {
            return new PageResultDto(0, null, req.getPageSize().intValue());
        }
        Integer totalAmount = this.slotStatisticsService.getMediaDataAmount(req, appIdsByName);
        ArrayList<RspMediaAppStatisticsDto> rspDtos = null;
        req.setPageSize(Integer.valueOf(10));
        if (totalAmount > 0 && totalAmount >= req.getRowStart()) {
            req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
            List<MediaAppStatisticsDto> mediaAppStatisticsDtos = this.slotStatisticsService.getMediaDataByPage(req, appIdsByName);
            int size = mediaAppStatisticsDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            for (MediaAppStatisticsDto MediaAppStatisticsDto2 : mediaAppStatisticsDtos) {
                appIds.add(MediaAppStatisticsDto2.getAppId());
            }
            rspDtos = new ArrayList<RspMediaAppStatisticsDto>(size);
            HashMap<Long, String> appMap = null;
            if (CollectionUtils.isNotEmpty(appIds)) {
                List<IdAndName> appIdAndNameList = this.mediaAppService.selectAppIdAndName(appIds);
                appMap = new HashMap<Long, String>(appIds.size());
                for (IdAndName appVO : appIdAndNameList) {
                    appMap.put(appVO.getId(), appVO.getName());
                }
            }
            for (MediaAppStatisticsDto dto : mediaAppStatisticsDtos) {
                RspMediaAppStatisticsDto rspDto = new RspMediaAppStatisticsDto();
                rspDto.setAppId(dto.getAppId());
                rspDto.setClickCount(dto.getClickCount());
                rspDto.setConsumeTotal(dto.getConsumeTotal());
                rspDto.setExposureCount(dto.getExposureCount());
                rspDto.setPlatform(dto.getPlatform());
                if (appMap != null) {
                    rspDto.setAppName((String)appMap.get(dto.getAppId()));
                }
                rspDto.seteCpm(DataTool.calculateEcpm((Long)dto.getConsumeTotal(), (Long)dto.getExposureCount()));
                rspDto.setCpc(DataTool.calculateAveragePrice((Long)dto.getConsumeTotal(), (Long)dto.getClickCount()));
                rspDtos.add(rspDto);
            }
        }
        return new PageResultDto(totalAmount.intValue(), rspDtos, req.getPageSize().intValue());
    }
}

