/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.AlipaySystemOauthTokenResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipaySystemOauthTokenRequest
implements TaobaoRequest<AlipaySystemOauthTokenResponse> {
    private Map<String, String> headerMap = new TaobaoHashMap();
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String code;
    private String grantType;
    private String refreshToken;

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "alipay.system.oauth.token";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("code", this.code);
        txtParams.put("grant_type", this.grantType);
        txtParams.put("refresh_token", this.refreshToken);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Class<AlipaySystemOauthTokenResponse> getResponseClass() {
        return AlipaySystemOauthTokenResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMaxLength(this.code, 40, "code");
        RequestCheckUtils.checkNotEmpty(this.grantType, "grantType");
        RequestCheckUtils.checkMaxLength(this.grantType, 20, "grantType");
        RequestCheckUtils.checkMaxLength(this.refreshToken, 40, "refreshToken");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

