/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.filter.impl;

import com.alibaba.rocketmq.common.filter.impl.Op;
import com.alibaba.rocketmq.common.filter.impl.Operand;
import com.alibaba.rocketmq.common.filter.impl.Operator;
import com.alibaba.rocketmq.common.filter.impl.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class PolishExpr {
    private static List<Op> participle(String expression) {
        ArrayList<Op> segments = new ArrayList<Op>();
        int size = expression.length();
        int wordStartIndex = -1;
        int wordLen = 0;
        Type preType = Type.NULL;
        for (int i = 0; i < size; ++i) {
            char chValue = expression.charAt(i);
            if ('a' <= chValue && chValue <= 'z' || 'A' <= chValue && chValue <= 'Z' || '1' <= chValue && chValue <= '9' || '_' == chValue) {
                if (Type.OPERATOR == preType || Type.SEPAERATOR == preType || Type.NULL == preType || Type.PARENTHESIS == preType) {
                    if (Type.OPERATOR == preType) {
                        segments.add(Operator.createOperator(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    }
                    wordStartIndex = i;
                    wordLen = 0;
                }
                preType = Type.OPERAND;
                ++wordLen;
                continue;
            }
            if ('(' == chValue || ')' == chValue) {
                if (Type.OPERATOR == preType) {
                    segments.add(Operator.createOperator(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    wordStartIndex = -1;
                    wordLen = 0;
                } else if (Type.OPERAND == preType) {
                    segments.add(new Operand(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    wordStartIndex = -1;
                    wordLen = 0;
                }
                preType = Type.PARENTHESIS;
                segments.add(Operator.createOperator((char)chValue + ""));
                continue;
            }
            if ('&' == chValue || '|' == chValue) {
                if (Type.OPERAND == preType || Type.SEPAERATOR == preType || Type.PARENTHESIS == preType) {
                    if (Type.OPERAND == preType) {
                        segments.add(new Operand(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    }
                    wordStartIndex = i;
                    wordLen = 0;
                }
                preType = Type.OPERATOR;
                ++wordLen;
                continue;
            }
            if (' ' == chValue || '\t' == chValue) {
                if (Type.OPERATOR == preType) {
                    segments.add(Operator.createOperator(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    wordStartIndex = -1;
                    wordLen = 0;
                } else if (Type.OPERAND == preType) {
                    segments.add(new Operand(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
                    wordStartIndex = -1;
                    wordLen = 0;
                }
                preType = Type.SEPAERATOR;
                continue;
            }
            throw new IllegalArgumentException("illegal expression, at index " + i + " " + (char)chValue);
        }
        if (wordLen > 0) {
            segments.add(new Operand(expression.substring(wordStartIndex, wordStartIndex + wordLen)));
        }
        return segments;
    }

    public static List<Op> reversePolish(String expression) {
        return PolishExpr.reversePolish(PolishExpr.participle(expression));
    }

    public static List<Op> reversePolish(List<Op> tokens) {
        ArrayList<Op> segments = new ArrayList<Op>();
        Stack<Operator> operatorStack = new Stack<Operator>();
        for (int i = 0; i < tokens.size(); ++i) {
            Operator opNew;
            Op token = tokens.get(i);
            if (PolishExpr.isOperand(token)) {
                segments.add(token);
                continue;
            }
            if (PolishExpr.isLeftParenthesis(token)) {
                operatorStack.push((Operator)token);
                continue;
            }
            if (PolishExpr.isRightParenthesis(token)) {
                opNew = null;
                while (!operatorStack.empty() && Operator.LEFTPARENTHESIS != (opNew = (Operator)operatorStack.pop())) {
                    segments.add(opNew);
                }
                if (null != opNew && Operator.LEFTPARENTHESIS == opNew) continue;
                throw new IllegalArgumentException("mismatched parentheses");
            }
            if (PolishExpr.isOperator(token)) {
                Operator opOld;
                opNew = (Operator)token;
                if (!operatorStack.empty() && (opOld = (Operator)operatorStack.peek()).isCompareable() && opNew.compare(opOld) != 1) {
                    segments.add((Op)operatorStack.pop());
                }
                operatorStack.push(opNew);
                continue;
            }
            throw new IllegalArgumentException("illegal token " + token);
        }
        while (!operatorStack.empty()) {
            Operator operator = (Operator)operatorStack.pop();
            if (Operator.LEFTPARENTHESIS == operator || Operator.RIGHTPARENTHESIS == operator) {
                throw new IllegalArgumentException("mismatched parentheses " + operator);
            }
            segments.add(operator);
        }
        return segments;
    }

    public static boolean isOperand(Op token) {
        return token instanceof Operand;
    }

    public static boolean isOperator(Op token) {
        return token instanceof Operator;
    }

    public static boolean isLeftParenthesis(Op token) {
        return token instanceof Operator && Operator.LEFTPARENTHESIS == (Operator)token;
    }

    public static boolean isRightParenthesis(Op token) {
        return token instanceof Operator && Operator.RIGHTPARENTHESIS == (Operator)token;
    }
}

