/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSSUtils {
    private static final String DEFAULT_OBJECT_CONTENT_TYPE = "application/octet-stream";
    public static final ResourceManager OSS_RESOURCE_MANAGER;
    private static final String DEFAULT_ROOT_DOMAIN = ".aliyuncs.com,.aliyun-inc.com,localhost";
    private static final String OSS_CONFIG_ROOT_DOMAIN = "oss.config.root_domain";
    private static List<String> rootDomains;

    public static boolean validateBucketName(String bucketName) {
        if (bucketName == null) {
            return false;
        }
        String BUCKET_REGEX = "^[a-z0-9][a-z0-9_\\-]{2,62}$";
        return bucketName.matches("^[a-z0-9][a-z0-9_\\-]{2,62}$");
    }

    public static void ensureBucketNameValid(String bucketName) {
        if (!OSSUtils.validateBucketName(bucketName)) {
            throw new IllegalArgumentException(OSS_RESOURCE_MANAGER.getString("BucketNameInvalid"));
        }
    }

    public static boolean validateObjectKey(String key) {
        byte[] bytes;
        if (key == null) {
            return false;
        }
        try {
            bytes = key.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        char[] keyChars = key.toCharArray();
        char beginKeyChar = keyChars[0];
        if (beginKeyChar == '/' || beginKeyChar == '\\') {
            return false;
        }
        for (char keyChar : keyChars) {
            if (keyChar == '\t' || keyChar >= ' ') continue;
            return false;
        }
        return bytes.length > 0 && bytes.length < 1024;
    }

    public static void ensureObjectKeyValid(String key) {
        if (!OSSUtils.validateObjectKey(key)) {
            throw new IllegalArgumentException(OSS_RESOURCE_MANAGER.getString("ObjectKeyInvalid"));
        }
    }

    public static URI makeBukcetEndpoint(URI endpoint, String bucket) {
        try {
            return new URI(endpoint.getScheme(), null, bucket != null && !OSSUtils.isCName(endpoint.getHost()) ? bucket + "." + endpoint.getHost() : endpoint.getHost(), endpoint.getPort(), endpoint.getPath(), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean isCName(String host) {
        if (host != null && !host.trim().isEmpty()) {
            String domain = host.toLowerCase();
            for (String str : rootDomains) {
                if (!domain.endsWith(str)) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException("Host name can not be null.");
    }

    public static String makeResourcePath(String key) {
        return key != null ? OSSUtils.urlEncodeKey(key) : null;
    }

    public static String makeResourcePath(String bucket, String key) {
        if (bucket != null) {
            return bucket + (key != null ? "/" + OSSUtils.urlEncodeKey(key) : "");
        }
        return null;
    }

    private static String urlEncodeKey(String key) {
        String[] keys = key.split("/");
        StringBuffer uri = new StringBuffer();
        try {
            int i;
            uri.append(HttpUtil.urlEncode(keys[0], "utf-8"));
            for (i = 1; i < keys.length; ++i) {
                uri.append("/").append(HttpUtil.urlEncode(keys[i], "utf-8"));
            }
            if (key.endsWith("/")) {
                for (i = key.length() - 1; i >= 0 && key.charAt(i) == '/'; --i) {
                    uri.append("/");
                }
            }
            return uri.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(OSS_RESOURCE_MANAGER.getFormattedString("FailedToEncodeObjectKey", key, "utf-8"), e);
        }
    }

    public static void populateRequestMetadata(Map<String, String> headers, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                headers.put(entry.getKey(), entry.getValue().toString());
            }
            if (!rawMetadata.keySet().contains("Content-Type")) {
                headers.put("Content-Type", DEFAULT_OBJECT_CONTENT_TYPE);
            }
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                headers.put("x-oss-meta-" + key, value);
            }
        }
    }

    public static void addHeader(Map<String, String> headers, String header, String value) {
        if (value != null) {
            headers.put(header, value);
        }
    }

    public static void addDateHeader(Map<String, String> headers, String header, Date value) {
        if (value != null) {
            headers.put(header, DateUtil.formatRfc822Date(value));
        }
    }

    public static void addListHeader(Map<String, String> headers, String header, List<String> values) {
        if (values != null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String value : values) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(value);
                first = false;
            }
            headers.put(header, sb.toString());
        }
    }

    public static String trimQuotes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static Map<String, String> getResponseHeaderParameters(ResponseHeaderOverrides responseHeader) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (responseHeader != null) {
            if (responseHeader.getCacheControl() != null) {
                params.put("response-cache-control", responseHeader.getCacheControl());
            }
            if (responseHeader.getContentDisposition() != null) {
                params.put("response-content-disposition", responseHeader.getContentDisposition());
            }
            if (responseHeader.getContentEncoding() != null) {
                params.put("response-content-encoding", responseHeader.getContentEncoding());
            }
            if (responseHeader.getContentLangauge() != null) {
                params.put("response-content-language", responseHeader.getContentLangauge());
            }
            if (responseHeader.getContentType() != null) {
                params.put("response-content-type", responseHeader.getContentType());
            }
            if (responseHeader.getExpires() != null) {
                params.put("response-expires", responseHeader.getExpires());
            }
        }
        return params;
    }

    public static void safeCloseResponse(ResponseMessage response) {
        assert (response != null);
        try {
            response.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        String[] domains;
        OSS_RESOURCE_MANAGER = ResourceManager.getInstance("oss");
        rootDomains = new ArrayList<String>();
        String domainString = System.getProperty(OSS_CONFIG_ROOT_DOMAIN, DEFAULT_ROOT_DOMAIN);
        if (domainString.trim().isEmpty()) {
            domainString = DEFAULT_ROOT_DOMAIN;
        }
        for (String str : domains = domainString.split(",")) {
            if (str.trim().isEmpty()) continue;
            rootDomains.add(str.trim().toLowerCase());
        }
    }
}

