/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.MapReturnValueAware;
import net.rubyeye.xmemcached.command.MergeCommandsAware;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.BinaryDecodeStatus;
import net.rubyeye.xmemcached.command.binary.BinaryGetCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGetMultiCommand
extends BaseBinaryCommand
implements MergeCommandsAware,
MapReturnValueAware {
    private boolean finished;
    private String responseKey;
    private long responseCAS;
    private int responseFlag;
    private Map<Object, Command> mergeCommands;

    public BinaryGetMultiCommand(String key, CommandType cmdType, CountDownLatch latch) {
        super(key, null, cmdType, latch, 0, 0L, null, false, null);
        this.result = new HashMap();
    }

    @Override
    public Map<String, CachedData> getReturnValues() {
        return (Map)this.result;
    }

    @Override
    protected boolean readOpCode(ByteBuffer buffer) {
        byte opCode = buffer.get();
        if (opCode == OpCode.GET_KEY.fieldValue()) {
            this.finished = true;
        }
        return true;
    }

    @Override
    protected void readHeader(ByteBuffer buffer) {
        super.readHeader(buffer);
        if (this.responseStatus != ResponseStatus.NO_ERROR && ByteUtils.stepBuffer(buffer, this.responseTotalBodyLength)) {
            this.decodeStatus = BinaryDecodeStatus.DONE;
        }
    }

    @Override
    public void encode() {
    }

    @Override
    protected boolean finish() {
        BinaryGetCommand command;
        CachedData cachedData = (CachedData)((Map)this.result).get(this.responseKey);
        Map<Object, Command> mergetCommands = this.getMergeCommands();
        if (mergetCommands != null && (command = (BinaryGetCommand)mergetCommands.remove(this.responseKey)) != null) {
            command.setResult(cachedData);
            command.countDownLatch();
            --this.mergeCount;
            if (command.getAssocCommands() != null) {
                for (Command assocCommand : command.getAssocCommands()) {
                    assocCommand.setResult(cachedData);
                    assocCommand.countDownLatch();
                    --this.mergeCount;
                }
            }
        }
        if (this.finished) {
            if (this.getMergeCommands() != null) {
                Collection<Command> mergeCommands = this.getMergeCommands().values();
                this.getIoBuffer().free();
                for (Command nextCommand : mergeCommands) {
                    BinaryGetCommand command2 = (BinaryGetCommand)nextCommand;
                    command2.countDownLatch();
                    if (command2.getAssocCommands() == null) continue;
                    for (Command assocCommand : command2.getAssocCommands()) {
                        assocCommand.countDownLatch();
                    }
                }
            }
            this.countDownLatch();
        } else {
            this.responseKey = null;
        }
        return this.finished;
    }

    @Override
    protected boolean readKey(ByteBuffer buffer, int keyLength) {
        if (buffer.remaining() < keyLength) {
            return false;
        }
        if (keyLength > 0) {
            byte[] bytes = new byte[keyLength];
            buffer.get(bytes);
            this.responseKey = ByteUtils.getString(bytes);
            CachedData value = new CachedData();
            value.setCas(this.responseCAS);
            value.setFlag(this.responseFlag);
            ((Map)this.result).put(this.responseKey, value);
        }
        return true;
    }

    @Override
    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        if (this.responseStatus == ResponseStatus.NO_ERROR) {
            int valueLength = bodyLength - keyLength - extrasLength;
            CachedData responseValue = (CachedData)((Map)this.result).get(this.responseKey);
            if (valueLength >= 0 && responseValue.getCapacity() < 0) {
                responseValue.setCapacity(valueLength);
                responseValue.setData(new byte[valueLength]);
            }
            int remainingCapacity = responseValue.remainingCapacity();
            int remaining = buffer.remaining();
            if (remaining < remainingCapacity) {
                int length = remaining > remainingCapacity ? remainingCapacity : remaining;
                responseValue.fillData(buffer, length);
                return false;
            }
            if (remainingCapacity > 0) {
                responseValue.fillData(buffer, remainingCapacity);
            }
            return true;
        }
        ((Map)this.result).remove(this.responseKey);
        return true;
    }

    @Override
    protected boolean readExtras(ByteBuffer buffer, int extrasLength) {
        if (buffer.remaining() < extrasLength) {
            return false;
        }
        if (extrasLength == 4) {
            this.responseFlag = buffer.getInt();
        }
        return true;
    }

    @Override
    protected long readCAS(ByteBuffer buffer) {
        this.responseCAS = buffer.getLong();
        return this.responseCAS;
    }

    @Override
    public Map<Object, Command> getMergeCommands() {
        return this.mergeCommands;
    }

    @Override
    public void setMergeCommands(Map<Object, Command> mergeCommands) {
        this.mergeCommands = mergeCommands;
    }
}

