/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.core.impl.FutureImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.MemcachedOptimizer;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.command.AssocCommandAware;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.OperationStatus;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.BinaryGetCommand;
import net.rubyeye.xmemcached.command.binary.BinaryGetMultiCommand;
import net.rubyeye.xmemcached.command.binary.BinarySetMultiCommand;
import net.rubyeye.xmemcached.command.binary.BinaryStoreCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.text.TextGetOneCommand;
import net.rubyeye.xmemcached.impl.MemcachedHandler;
import net.rubyeye.xmemcached.impl.OptimizerMBean;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.monitor.MemcachedClientNameHolder;
import net.rubyeye.xmemcached.monitor.XMemcachedMbeanServer;
import net.rubyeye.xmemcached.utils.ByteUtils;
import net.rubyeye.xmemcached.utils.OpaqueGenerater;
import net.rubyeye.xmemcached.utils.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optimizer
implements OptimizerMBean,
MemcachedOptimizer {
    public static final int DEFAULT_MERGE_FACTOR = 50;
    private int mergeFactor = 50;
    private boolean optimiezeGet = true;
    private final boolean optimiezeSet = true;
    private boolean optimiezeMergeBuffer = true;
    private static final Logger log = LoggerFactory.getLogger(Optimizer.class);
    private Protocol protocol = Protocol.Binary;
    private final ThreadLocal<List<Command>> threadLocal = new ThreadLocal<List<Command>>(){

        @Override
        protected List<Command> initialValue() {
            return new ArrayList<Command>(Optimizer.this.mergeFactor);
        }
    };

    public Optimizer(Protocol protocol) {
        XMemcachedMbeanServer.getInstance().registMBean(this, this.getClass().getPackage().getName() + ":type=" + this.getClass().getSimpleName() + "-" + MemcachedClientNameHolder.getName());
        this.protocol = protocol;
    }

    @Override
    public void setBufferAllocator(BufferAllocator bufferAllocator) {
    }

    @Override
    public int getMergeFactor() {
        return this.mergeFactor;
    }

    @Override
    public void setMergeFactor(int mergeFactor) {
        if (this.mergeFactor != mergeFactor) {
            log.warn("change mergeFactor from " + this.mergeFactor + " to " + mergeFactor);
        }
        this.mergeFactor = mergeFactor;
    }

    @Override
    public boolean isOptimizeGet() {
        return this.optimiezeGet;
    }

    @Override
    public void setOptimizeGet(boolean optimiezeGet) {
        log.warn(optimiezeGet ? "Enable merge get commands" : "Disable merge get commands");
        this.optimiezeGet = optimiezeGet;
    }

    @Override
    public boolean isOptimizeMergeBuffer() {
        return this.optimiezeMergeBuffer;
    }

    @Override
    public void setOptimizeMergeBuffer(boolean optimiezeMergeBuffer) {
        log.warn(optimiezeMergeBuffer ? "Enable merge buffers" : "Disable merge buffers");
        this.optimiezeMergeBuffer = optimiezeMergeBuffer;
    }

    @Override
    public Command optimize(Command currentCommand, Queue writeQueue, Queue<Command> executingCmds, int sendBufferSize) {
        Command optimiezeCommand = currentCommand;
        optimiezeCommand = this.optimiezeGet(writeQueue, executingCmds, optimiezeCommand);
        optimiezeCommand = this.optimiezeSet(writeQueue, executingCmds, optimiezeCommand, sendBufferSize);
        optimiezeCommand = this.optimiezeMergeBuffer(optimiezeCommand, writeQueue, executingCmds, sendBufferSize);
        return optimiezeCommand;
    }

    public final Command optimiezeMergeBuffer(Command optimiezeCommand, Queue writeQueue, Queue<Command> executingCmds, int sendBufferSize) {
        if (log.isDebugEnabled()) {
            log.debug("Optimieze merge buffer:" + optimiezeCommand.toString());
        }
        if (this.optimiezeMergeBuffer && optimiezeCommand.getIoBuffer().remaining() < sendBufferSize) {
            optimiezeCommand = this.mergeBuffer(optimiezeCommand, writeQueue, executingCmds, sendBufferSize);
        }
        return optimiezeCommand;
    }

    public final Command optimiezeGet(Queue writeQueue, Queue<Command> executingCmds, Command optimiezeCommand) {
        if ((optimiezeCommand.getCommandType() == CommandType.GET_ONE || optimiezeCommand.getCommandType() == CommandType.GETS_ONE) && this.optimiezeGet) {
            optimiezeCommand = this.mergeGetCommands(optimiezeCommand, writeQueue, executingCmds, optimiezeCommand.getCommandType());
        }
        return optimiezeCommand;
    }

    public final Command optimiezeSet(Queue writeQueue, Queue<Command> executingCmds, Command optimiezeCommand, int sendBufferSize) {
        this.getClass();
        if (optimiezeCommand.getCommandType() == CommandType.SET && !optimiezeCommand.isNoreply() && this.protocol == Protocol.Binary) {
            optimiezeCommand = this.mergeSetCommands(optimiezeCommand, writeQueue, executingCmds, optimiezeCommand.getCommandType(), sendBufferSize);
        }
        return optimiezeCommand;
    }

    private final Command mergeBuffer(Command firstCommand, Queue writeQueue, Queue<Command> executingCmds, int sendBufferSize) {
        Command lastCommand = firstCommand;
        Command nextCmd = (Command)writeQueue.peek();
        if (nextCmd == null) {
            return lastCommand;
        }
        List<Command> commands = this.getLocalList();
        ByteBuffer firstBuffer = firstCommand.getIoBuffer().buf();
        int totalBytes = firstBuffer.remaining();
        commands.add(firstCommand);
        boolean wasFirst = true;
        while (totalBytes + nextCmd.getIoBuffer().remaining() <= sendBufferSize && (nextCmd = (Command)writeQueue.peek()) != null && nextCmd.getStatus() != OperationStatus.WRITING) {
            if (nextCmd.isCancel()) {
                writeQueue.remove();
                continue;
            }
            nextCmd.setStatus(OperationStatus.WRITING);
            writeQueue.remove();
            if (wasFirst) {
                wasFirst = false;
            }
            if ((nextCmd.getCommandType() == CommandType.GET_ONE || nextCmd.getCommandType() == CommandType.GETS_ONE) && this.optimiezeGet) {
                nextCmd = this.mergeGetCommands(nextCmd, writeQueue, executingCmds, nextCmd.getCommandType());
            }
            commands.add(nextCmd);
            lastCommand = nextCmd;
            if ((totalBytes += nextCmd.getIoBuffer().remaining()) <= sendBufferSize) continue;
        }
        if (commands.size() > 1) {
            byte[] buf = new byte[totalBytes];
            int offset = 0;
            for (Command command : commands) {
                byte[] ba = command.getIoBuffer().array();
                System.arraycopy(ba, 0, buf, offset, ba.length);
                offset += ba.length;
                if (command == lastCommand || command.isNoreply() && !(command instanceof BaseBinaryCommand)) continue;
                executingCmds.add(command);
            }
            lastCommand.setIoBuffer(IoBuffer.wrap(buf));
        }
        return lastCommand;
    }

    public final List<Command> getLocalList() {
        List<Command> list = this.threadLocal.get();
        list.clear();
        return list;
    }

    private final Command mergeGetCommands(Command currentCmd, Queue writeQueue, Queue<Command> executingCmds, CommandType expectedCommandType) {
        Command nextCmd;
        HashMap<String, Command> mergeCommands = null;
        int mergeCount = 1;
        CommandCollector commandCollector = this.createGetCommandCollector();
        currentCmd.setStatus(OperationStatus.WRITING);
        commandCollector.visit(currentCmd);
        while (mergeCount < this.mergeFactor && (nextCmd = (Command)writeQueue.peek()) != null) {
            if (nextCmd.isCancel()) {
                writeQueue.remove();
                continue;
            }
            if (nextCmd.getCommandType() != expectedCommandType) break;
            if (mergeCommands == null) {
                mergeCommands = new HashMap<String, Command>(this.mergeFactor / 2);
                mergeCommands.put(currentCmd.getKey(), currentCmd);
            }
            if (log.isDebugEnabled()) {
                log.debug("Merge get command:" + nextCmd.toString());
            }
            nextCmd.setStatus(OperationStatus.WRITING);
            Command removedCommand = (Command)writeQueue.remove();
            if (mergeCommands.containsKey(removedCommand.getKey())) {
                AssocCommandAware mergedGetCommand = (AssocCommandAware)mergeCommands.get(removedCommand.getKey());
                if (mergedGetCommand.getAssocCommands() == null) {
                    mergedGetCommand.setAssocCommands(new ArrayList<Command>(5));
                }
                mergedGetCommand.getAssocCommands().add(removedCommand);
            } else {
                commandCollector.visit(nextCmd);
                mergeCommands.put(removedCommand.getKey(), removedCommand);
            }
            ++mergeCount;
        }
        if (mergeCount == 1) {
            return currentCmd;
        }
        commandCollector.finish();
        if (log.isDebugEnabled()) {
            log.debug("Merge optimieze:merge " + mergeCount + " get commands");
        }
        return this.newMergedCommand(mergeCommands, mergeCount, commandCollector, expectedCommandType);
    }

    private final Command mergeSetCommands(Command currentCmd, Queue writeQueue, Queue<Command> executingCmds, CommandType expectedCommandType, int sendBufferSize) {
        Command nextCmd;
        int mergeCount = 1;
        BinarySetQCollector commandCollector = new BinarySetQCollector();
        currentCmd.setStatus(OperationStatus.WRITING);
        int totalBytes = currentCmd.getIoBuffer().remaining();
        commandCollector.visit(currentCmd);
        while (mergeCount < this.mergeFactor && totalBytes <= sendBufferSize && (nextCmd = (Command)writeQueue.peek()) != null) {
            if (nextCmd.isCancel()) {
                writeQueue.remove();
                continue;
            }
            if (nextCmd.getCommandType() != expectedCommandType || nextCmd.isNoreply()) break;
            if (log.isDebugEnabled()) {
                log.debug("Merge set command:" + nextCmd.toString());
            }
            nextCmd.setStatus(OperationStatus.WRITING);
            writeQueue.remove();
            commandCollector.visit(nextCmd);
            ++mergeCount;
            totalBytes += nextCmd.getIoBuffer().remaining();
        }
        if (mergeCount == 1) {
            return currentCmd;
        }
        commandCollector.finish();
        if (log.isDebugEnabled()) {
            log.debug("Merge optimieze:merge " + mergeCount + " get commands");
        }
        return (Command)commandCollector.getResult();
    }

    private CommandCollector createGetCommandCollector() {
        switch (this.protocol) {
            case Binary: {
                return new BinaryGetQCollector();
            }
        }
        return new KeyStringCollector();
    }

    private Command newMergedCommand(Map<Object, Command> mergeCommands, int mergeCount, CommandCollector commandCollector, CommandType commandType) {
        if (this.protocol == Protocol.Text) {
            String resultKey = (String)commandCollector.getResult();
            byte[] keyBytes = ByteUtils.getBytes(resultKey);
            byte[] cmdBytes = commandType == CommandType.GET_ONE ? Constants.GET : Constants.GETS;
            byte[] buf = new byte[cmdBytes.length + 3 + keyBytes.length];
            ByteUtils.setArguments(buf, 0, cmdBytes, keyBytes);
            TextGetOneCommand cmd = new TextGetOneCommand(resultKey, keyBytes, commandType, null);
            cmd.setMergeCommands(mergeCommands);
            cmd.setWriteFuture(new FutureImpl<Boolean>());
            cmd.setMergeCount(mergeCount);
            cmd.setIoBuffer(IoBuffer.wrap(buf));
            return cmd;
        }
        BinaryGetMultiCommand result = (BinaryGetMultiCommand)commandCollector.getResult();
        result.setMergeCount(mergeCount);
        result.setMergeCommands(mergeCommands);
        return result;
    }

    private static class BinaryGetQCollector
    implements CommandCollector {
        LinkedList<IoBuffer> bufferList = new LinkedList();
        int totalBytes;
        Command prevCommand;

        private BinaryGetQCollector() {
        }

        public Object getResult() {
            byte[] buf = new byte[this.totalBytes];
            int offset = 0;
            for (IoBuffer buffer : this.bufferList) {
                byte[] ba = buffer.array();
                System.arraycopy(ba, 0, buf, offset, ba.length);
                offset += ba.length;
            }
            BinaryGetMultiCommand resultCommand = new BinaryGetMultiCommand(null, CommandType.GET_MANY, new CountDownLatch(1));
            resultCommand.setIoBuffer(IoBuffer.wrap(buf));
            return resultCommand;
        }

        public void visit(Command command) {
            if (this.prevCommand != null) {
                BinaryGetCommand getqCommand = new BinaryGetCommand(this.prevCommand.getKey(), this.prevCommand.getKeyBytes(), null, null, OpCode.GET_KEY_QUIETLY, true);
                ((Command)getqCommand).encode();
                this.totalBytes += getqCommand.getIoBuffer().remaining();
                this.bufferList.add(getqCommand.getIoBuffer());
            }
            this.prevCommand = command;
        }

        public void finish() {
            BinaryGetCommand lastGetKCommand = new BinaryGetCommand(this.prevCommand.getKey(), this.prevCommand.getKeyBytes(), CommandType.GET_ONE, new CountDownLatch(1), OpCode.GET_KEY, false);
            ((Command)lastGetKCommand).encode();
            this.bufferList.add(lastGetKCommand.getIoBuffer());
            this.totalBytes += lastGetKCommand.getIoBuffer().remaining();
        }
    }

    private static class BinarySetQCollector
    implements CommandCollector {
        LinkedList<IoBuffer> bufferList = new LinkedList();
        int totalBytes;
        BinaryStoreCommand prevCommand;
        Map<Object, Command> mergeCommands;

        private BinarySetQCollector() {
        }

        public Object getResult() {
            byte[] buf = new byte[this.totalBytes];
            int offset = 0;
            for (IoBuffer buffer : this.bufferList) {
                byte[] ba = buffer.array();
                System.arraycopy(ba, 0, buf, offset, ba.length);
                offset += ba.length;
            }
            BinarySetMultiCommand resultCommand = new BinarySetMultiCommand(null, CommandType.SET_MANY, new CountDownLatch(1));
            resultCommand.setIoBuffer(IoBuffer.wrap(buf));
            resultCommand.setMergeCommands(this.mergeCommands);
            resultCommand.setMergeCount(this.mergeCommands.size());
            return resultCommand;
        }

        public void visit(Command command) {
            if (this.prevCommand != null) {
                BinaryStoreCommand setqCmd = new BinaryStoreCommand(this.prevCommand.getKey(), this.prevCommand.getKeyBytes(), CommandType.SET, null, this.prevCommand.getExpTime(), this.prevCommand.getCas(), this.prevCommand.getValue(), true, this.prevCommand.getTranscoder());
                int opaque = OpaqueGenerater.getInstance().getNextValue();
                setqCmd.setOpaque(opaque);
                setqCmd.encode();
                this.totalBytes += setqCmd.getIoBuffer().remaining();
                this.bufferList.add(setqCmd.getIoBuffer());
                setqCmd.setIoBuffer(MemcachedHandler.EMPTY_BUF);
                setqCmd.setValue(null);
                this.prevCommand.setValue(null);
                this.prevCommand.setIoBuffer(MemcachedHandler.EMPTY_BUF);
                if (this.mergeCommands == null) {
                    this.mergeCommands = new HashMap<Object, Command>();
                }
                this.mergeCommands.put(opaque, this.prevCommand);
            }
            this.prevCommand = (BinaryStoreCommand)command;
        }

        public void finish() {
            if (this.mergeCommands == null) {
                return;
            }
            BinaryStoreCommand setqCmd = new BinaryStoreCommand(this.prevCommand.getKey(), this.prevCommand.getKeyBytes(), CommandType.SET, null, this.prevCommand.getExpTime(), this.prevCommand.getCas(), this.prevCommand.getValue(), false, this.prevCommand.getTranscoder());
            int opaque = OpaqueGenerater.getInstance().getNextValue();
            setqCmd.setOpaque(opaque);
            setqCmd.encode();
            this.bufferList.add(setqCmd.getIoBuffer());
            this.totalBytes += setqCmd.getIoBuffer().remaining();
            if (this.mergeCommands != null) {
                this.mergeCommands.put(opaque, this.prevCommand);
            }
        }
    }

    static class KeyStringCollector
    implements CommandCollector {
        char[] buf = new char[32];
        int count = 0;
        boolean wasFirst = true;

        KeyStringCollector() {
        }

        public Object getResult() {
            return new String(this.buf, 0, this.count);
        }

        public void visit(Command command) {
            if (this.wasFirst) {
                this.append(command.getKey());
                this.wasFirst = false;
            } else {
                this.append(" ");
                this.append(command.getKey());
            }
        }

        private void expandCapacity(int minimumCapacity) {
            int newCapacity = (this.buf.length + 1) * 2;
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            } else if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buf, 0, copy, 0, Math.min(this.buf.length, newCapacity));
            this.buf = copy;
        }

        private void append(String str) {
            int len = str.length();
            if (len == 0) {
                return;
            }
            int newCount = this.count + len;
            if (newCount > this.buf.length) {
                this.expandCapacity(newCount);
            }
            str.getChars(0, len, this.buf, this.count);
            this.count = newCount;
        }

        public void finish() {
        }
    }

    static interface CommandCollector {
        public Object getResult();

        public void visit(Command var1);

        public void finish();
    }
}

