/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.MediaAppActivityService;
import cn.com.duiba.tuia.media.service.SlotService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivitySortServiceImpl
implements ActivitySortService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long SORT_STEP = 10000L;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private SlotService slotService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySlotService activitySlotService;
    @Autowired
    private MediaAppActivityService mediaAppActivityService;

    @Override
    public int insertBatchActivitySort(List<ActivitySortDto> activitySortDtoList) throws TuiaMediaException {
        return this.activitySortDAO.insertBatch(activitySortDtoList);
    }

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        if (!StringUtils.isEmpty((Object)reqActivitySort.getName())) {
            List<Long> list = this.activityService.getIdsByName(reqActivitySort.getName());
            if (CollectionUtils.isEmpty(list)) {
                return new ArrayList<ActivitySortDto>();
            }
            reqActivitySort.setActivityIds(list);
        }
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        return this.activitySortDAO.selectByConditionAmount(reqActivitySort);
    }

    @Override
    @Transactional
    public boolean deleteActivity(Long activityId, Integer activityType, Long slotId) throws TuiaMediaException {
        if (activityId == null || activityType == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        return this.activitySortDAO.deleteActivity(slotId, activityId, activityType) > 0;
    }

    @Override
    public ActivitySortDto getMaxSortValueActivitySortDto(Long slotId) throws TuiaMediaException {
        if (slotId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        reqActivitySort.setSort("activity_sort desc,gmt_modified asc");
        reqActivitySort.setRowStart(0);
        reqActivitySort.setPageSize(Integer.valueOf(1));
        List<ActivitySortDto> result = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public List<RspActivityDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        if (appId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        List<ActivitySortDto> sortList = this.activitySortDAO.getActivityForRecommendByApp(appId);
        ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
        for (ActivitySortDto activitySortDto : sortList) {
            RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType());
            result.add(rspActivityDto);
        }
        return result;
    }

    private List<ActivitySortDto> getActivityBySlot(Long slotId) throws TuiaMediaException {
        ActivitySlotDO activitySlot = this.activitySlotService.getBySlotId(slotId);
        if (activitySlot == null) {
            return this.activitySortDAO.getActivityForRecommendBySlot(0L);
        }
        List<ActivitySortDto> customSortList = this.activitySortDAO.getActivityForRecommendBySlot(slotId);
        if (CollectionUtils.isEmpty(customSortList)) {
            return this.activitySortDAO.getActivityForRecommendBySlot(0L);
        }
        if (activitySlot.getDirectMode() == 1) {
            return customSortList;
        }
        if (activitySlot.getDirectMode() == 2) {
            for (int i = 0; i < customSortList.size(); ++i) {
                customSortList.get(i).setActivitySort(Long.valueOf(i));
            }
            List<ActivitySortDto> defaultSortList = this.activitySortDAO.getActivityForRecommendBySlot(0L);
            for (int j = 0; j < defaultSortList.size(); ++j) {
                defaultSortList.get(j).setActivitySort(Long.valueOf(j + customSortList.size()));
            }
            TreeSet<ActivitySortDto> customSortSet = new TreeSet<ActivitySortDto>(customSortList);
            customSortSet.addAll(defaultSortList);
            return new ArrayList<ActivitySortDto>(customSortSet);
        }
        return customSortList;
    }

    private boolean avilableMediaApp(Long appId, RspActivityDto activity) throws TuiaMediaException {
        if (activity == null || appId == null) {
            return false;
        }
        if (1 == activity.getIsDirectMedia()) {
            List<Long> directMediaApp = this.mediaAppActivityService.getActivityDirectedMediaApp(activity.getId(), activity.getType());
            if (CollectionUtils.isEmpty(directMediaApp)) {
                return true;
            }
            return directMediaApp.contains(appId);
        }
        return true;
    }

    @Override
    public List<RspActivityDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        if (slotId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        try {
            SlotDto slot = this.slotService.selectById(slotId);
            if (slot == null) {
                this.logger.error("Not found slot, slotId=" + slotId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            List<ActivitySortDto> sortList = this.getActivityBySlot(slotId);
            ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
            for (ActivitySortDto activitySortDto : sortList) {
                RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(activitySortDto.getActivityId(), activitySortDto.getActivityType());
                if (rspActivityDto == null || rspActivityDto.getIsEnable() != 1 || rspActivityDto.getIsPublish() != 1) continue;
                if (slot.getSlotType() == 9 && rspActivityDto.getMsIdList() != null && rspActivityDto.getMsIdList().contains(slot.getSlotMsId())) {
                    if (!this.avilableMediaApp(slot.getAppId(), rspActivityDto)) continue;
                    result.add(rspActivityDto);
                    continue;
                }
                if (slot.getSlotType() == 8 || slot.getSlotType() == 9 || !this.avilableMediaApp(slot.getAppId(), rspActivityDto)) continue;
                result.add(rspActivityDto);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.getActivityForRecommendBySlot is error");
            throw new TuiaMediaException(ErrorCode.E9999999, (Throwable)e);
        }
    }

    @Override
    public int addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            Long sort = new Date().getTime();
            ActivitySortDto result = this.getMaxSortValueActivitySortDto(slotId);
            if (result != null && result.getActivitySort() >= sort) {
                sort = result.getActivitySort() + 10000L;
            }
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setSlotId(slotId);
            List<ActivitySortDto> existList = this.selectByCondition(reqActivitySort);
            HashSet<String> existActivity = new HashSet<String>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                existActivity.add(activitySortDto.getActivityId() + "-" + activitySortDto.getActivityType());
            }
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            SlotDto slotDto = null;
            if (!slotId.equals(0L)) {
                slotDto = this.slotService.selectById(slotId);
            }
            for (ReqIdAndType idAndType : idAndTypes) {
                if (slotDto != null) {
                    RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetail(idAndType.getId(), idAndType.getType());
                    if (!this.avilableMediaApp(slotDto.getAppId(), rspActivityDto)) continue;
                }
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(idAndType.getId());
                reqIdAndType.setType(idAndType.getType());
                if (existActivity.contains(idAndType.getId() + "-" + idAndType.getType())) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivitySlotId(slotId);
                activitySortDto.setActivityId(idAndType.getId());
                activitySortDto.setActivityType(idAndType.getType());
                activitySortDto.setActivitySort(sort);
                sort = sort + 10000L;
                activitySortDtoList.add(activitySortDto);
            }
            if (!activitySortDtoList.isEmpty()) {
                return this.insertBatchActivitySort(activitySortDtoList);
            }
            return 0;
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.addActivitySort is error", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int addDefaultActivitySort(Long slotId) {
        try {
            ArrayList<ReqIdAndType> idAndTypes = new ArrayList<ReqIdAndType>();
            ReqActivitySort condition = new ReqActivitySort();
            condition.setSlotId(Long.valueOf(0L));
            condition.setSort("activity_sort asc,gmt_modified desc");
            List<ActivitySortDto> needList = this.selectByCondition(condition);
            for (ActivitySortDto activitySortDto : needList) {
                ReqIdAndType idAndType = new ReqIdAndType();
                idAndType.setId(activitySortDto.getActivityId());
                idAndType.setType(activitySortDto.getActivityType());
                idAndTypes.add(idAndType);
            }
            return this.addActivitySort(slotId, idAndTypes);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.addDefaultActivitySort is error", (Throwable)e);
            return 0;
        }
    }

    private ActivitySortDto resetActivitySort(Long slotId, ActivitySortDto startSort) throws TuiaMediaException {
        this.activitySortDAO.updateSortBatch(slotId, startSort.getActivitySort(), 10000L);
        return this.activitySortDAO.select(slotId, startSort.getActivityId(), startSort.getActivityType());
    }

    private int getActivitySortLocation(Long slotId, Long activityId, Integer activityType) throws TuiaMediaException {
        ActivitySortDto activitySort = this.activitySortDAO.select(slotId, activityId, activityType);
        return this.activitySortDAO.selectSortLocation(slotId, activitySort.getActivitySort());
    }

    private long getActivitySortValue(Long slotId, List<ActivitySortDto> aroundSortList, int offset) throws TuiaMediaException {
        if (aroundSortList.size() == 1) {
            ActivitySortDto aroundSortMin = aroundSortList.get(0);
            return aroundSortMin.getActivitySort() + (offset < 0 ? -10000L : 10000L);
        }
        ActivitySortDto aroundSortMin = aroundSortList.get(0);
        ActivitySortDto aroundSortMax = aroundSortList.get(1);
        if (aroundSortMax.getActivitySort() - aroundSortMin.getActivitySort() < 2L) {
            aroundSortMax = this.resetActivitySort(slotId, aroundSortMax);
        }
        return (aroundSortMax.getActivitySort() + aroundSortMin.getActivitySort()) / 2L;
    }

    private Long getActivitySort(Long slotId, int destLocation, int offset) throws TuiaMediaException {
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        reqActivitySort.setPageSize(Integer.valueOf(destLocation == 1 ? 1 : 2));
        reqActivitySort.setRowStart(destLocation - 1 + offset < 0 ? 0 : destLocation - 1 + offset);
        reqActivitySort.setSort("activity_sort asc,gmt_modified desc");
        List<ActivitySortDto> aroundSortList = this.activitySortDAO.selectByCondition(reqActivitySort);
        if (aroundSortList.isEmpty()) {
            return null;
        }
        return this.getActivitySortValue(slotId, aroundSortList, offset);
    }

    @Override
    public boolean sortActivity(Long slotId, Long activityId, Integer activityType, int destLocation) throws TuiaMediaException {
        if (slotId == null || activityId == null || activityType == null || destLocation <= 0) {
            return false;
        }
        int origLocation = this.getActivitySortLocation(slotId, activityId, activityType);
        if (destLocation == origLocation) {
            return false;
        }
        int offset = destLocation < origLocation ? -1 : 0;
        Long sort = this.getActivitySort(slotId, destLocation, offset);
        if (sort == null) {
            return false;
        }
        return this.activitySortDAO.updateSort(slotId, activityId, activityType, sort) > 0;
    }
}

