/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqGetSlotsByPageDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspAdsenseSlotListDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.model.IdAndName;
import cn.com.duiba.tuia.media.model.req.ReqCreateSlot;
import cn.com.duiba.tuia.media.model.req.ReqEditSlotEnableStatus;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspSlot;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SlotServiceImpl
implements SlotService {
    @Autowired
    private SlotDAO slotDAO;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;

    @Override
    public Boolean insert(ReqCreateSlot req) throws TuiaMediaException {
        SlotDto slotDto = new SlotDto();
        slotDto.setMediaId(req.getMediaId());
        slotDto.setSlotName(req.getSlotName());
        slotDto.setEnableStatus(Integer.valueOf(1));
        slotDto.setSlotType(req.getSlotType());
        slotDto.setCheckStatus(Integer.valueOf(1));
        slotDto.setSlotMsId(req.getMsId());
        slotDto.setAppId(req.getAppId());
        slotDto.setStrategyId(req.getStrategyId());
        slotDto.setVisibleOfCloseButton(false);
        slotDto.setVisibleOfIco(false);
        this.slotDAO.insert(slotDto);
        if (slotDto.getStrategyId() != null) {
            this.slotCacheService.updateSlotCache(slotDto.getId());
        }
        if (slotDto.getId() != null) {
            this.slotCacheService.updateSoltIdAndNameCache(slotDto.getId());
        }
        return true;
    }

    @Override
    public Boolean update(ReqUpdateSlot param) throws TuiaMediaException {
        SlotDto slotDto = new SlotDto();
        slotDto.setId(param.getSlotId());
        slotDto.setSlotName(param.getSlotName());
        slotDto.setEnableStatus(Integer.valueOf(1));
        slotDto.setCheckStatus(Integer.valueOf(1));
        slotDto.setMediaId(param.getMediaId());
        slotDto.setStrategyId(param.getStrategyId());
        this.slotDAO.update(slotDto);
        if (slotDto.getStrategyId() != null) {
            this.slotCacheService.updateSlotCache(slotDto.getId());
            this.slotCacheService.updateSoltIdAndNameCache(slotDto.getId());
        }
        return true;
    }

    @Override
    public RspPageResult<RspSlot> selectListByPage(ReqSlotList param) throws TuiaMediaException {
        int count = this.slotDAO.selectAmountByPage(param);
        ArrayList<RspSlot> rspSlots = null;
        if (count > 0 && count >= param.getRowStart()) {
            List<SlotDto> slotDtos = this.slotDAO.selectListByPage(param);
            int size = slotDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            for (SlotDto slot : slotDtos) {
                appIds.add(slot.getAppId());
            }
            List<IdAndName> appIdAndNameList = this.mediaAppDao.selectAppIdAndName(appIds);
            HashMap<Long, String> appMap = new HashMap<Long, String>(size);
            for (IdAndName appVO : appIdAndNameList) {
                appMap.put(appVO.getId(), appVO.getName());
            }
            rspSlots = new ArrayList<RspSlot>(size);
            Map<Long, MaterialSpecificationDO> msMap = this.materialSpecificationService.getMapByIds(CollectionUtil.getFieldList(slotDtos, (String)"slotMsId"));
            for (SlotDto slot : slotDtos) {
                MaterialSpecificationDO ms;
                RspSlot rspSlot = new RspSlot();
                rspSlot.setSlotId(slot.getId());
                rspSlot.setSlotName(slot.getSlotName());
                rspSlot.setAppId(slot.getAppId());
                rspSlot.setAppName((String)appMap.get(slot.getAppId()));
                rspSlot.setCheckStatus(slot.getCheckStatus());
                rspSlot.setModifiedDate(new DateTime((Object)slot.getGmtModified()).toString("yyyy-MM-dd"));
                rspSlot.setSlotType(slot.getSlotType());
                rspSlot.setEnableStatus(slot.getEnableStatus());
                rspSlot.setActivityUrl(slot.getActivityUrl());
                rspSlot.setValid(true);
                rspSlot.setMsName(SlotDto.getSlotTypeNameBySlotType((int)slot.getSlotType()));
                if (slot.getSlotMsId() != null && (ms = msMap.get(slot.getSlotMsId())) != null) {
                    rspSlot.setMsName(ms.getTitle());
                    rspSlot.setValid(0 == ms.getIsDelete());
                }
                rspSlots.add(rspSlot);
            }
        }
        return new RspPageResult<RspSlot>(count, rspSlots, param.getPageSize());
    }

    @Override
    public SlotDto selectById(Long slotId) throws TuiaMediaException {
        return this.slotDAO.selectById(slotId);
    }

    @Override
    public Boolean updateEnableStatus(ReqEditSlotEnableStatus param) throws TuiaMediaException {
        long slotId = param.getSlotId();
        SlotDto slotDto = this.selectById(slotId);
        Integer enableStatus = param.getEnableStatus() != false ? 1 : 0;
        if (this.checkAppAndMediaStatus(slotDto)) {
            this.slotDAO.updateEnableStatus(slotId, enableStatus);
            this.slotCacheService.updateSlotCache(slotId);
        }
        return true;
    }

    private boolean checkAppAndMediaStatus(SlotDto adsenseDto) throws TuiaMediaException {
        if (1 != adsenseDto.getCheckStatus()) {
            throw new TuiaMediaException(ErrorCode.E0304006);
        }
        return true;
    }

    @Override
    public PageResultDto<RspAdsenseSlotListDto> selectAdsenseListByPage(ReqGetSlotsByPageDto req) throws TuiaMediaException {
        String appName = req.getAppName();
        List<Long> appIdsList = null;
        if (StringUtils.isNotBlank((CharSequence)appName) && CollectionUtils.isEmpty(appIdsList = this.mediaAppDao.selectIdsByName(appName))) {
            return new PageResultDto(0, null, req.getPageSize().intValue());
        }
        int count = this.slotDAO.selectAdsenseAmountByPage(req, appIdsList);
        ArrayList<RspAdsenseSlotListDto> rspSlots = null;
        if (count > 0 && count >= req.getRowStart()) {
            req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
            List<SlotDto> slotDtos = this.slotDAO.selectListAdsenseByPage(req, appIdsList);
            int size = slotDtos.size();
            ArrayList<Long> appIds = new ArrayList<Long>(size);
            for (SlotDto slot : slotDtos) {
                appIds.add(slot.getAppId());
            }
            List<IdAndName> appIdAndNameList = this.mediaAppDao.selectAppIdAndName(appIds);
            HashMap<Long, String> appMap = new HashMap<Long, String>(size);
            for (IdAndName appVO : appIdAndNameList) {
                appMap.put(appVO.getId(), appVO.getName());
            }
            Map<Long, MaterialSpecificationDO> msMap = this.materialSpecificationService.getMapByIds(CollectionUtil.getFieldList(slotDtos, (String)"slotMsId"));
            rspSlots = new ArrayList<RspAdsenseSlotListDto>(size);
            for (SlotDto slotDto : slotDtos) {
                RspAdsenseSlotListDto rspDto = new RspAdsenseSlotListDto();
                rspDto.setAppId(slotDto.getAppId());
                rspDto.setAppName((String)appMap.get(slotDto.getAppId()));
                rspDto.setCheckStatus(slotDto.getCheckStatus());
                rspDto.setCreateDate(new DateTime((Object)slotDto.getGmtCreate()).toString("yyyy-MM-dd"));
                rspDto.setSlotId(slotDto.getId());
                rspDto.setSlotName(slotDto.getSlotName());
                rspDto.setSlotType(slotDto.getSlotType());
                if (slotDto.getSlotMsId() == null) {
                    rspDto.setValid(Boolean.valueOf(true));
                    rspDto.setMsName(SlotDto.getSlotTypeNameBySlotType((int)slotDto.getSlotType()));
                } else {
                    MaterialSpecificationDO ms = msMap.get(slotDto.getSlotMsId());
                    if (ms != null) {
                        rspDto.setMsName(ms.getTitle());
                        rspDto.setValid(Boolean.valueOf(0 == ms.getIsDelete()));
                    }
                }
                rspSlots.add(rspDto);
            }
        }
        return new PageResultDto(count, rspSlots, req.getPageSize().intValue());
    }

    @Override
    public boolean batchUpdateCheckStatus(List<Long> slotIds, Integer checkType) throws TuiaMediaException {
        this.slotDAO.batchUpdateCheckStatus(slotIds, checkType);
        if (checkType == 1) {
            this.slotDAO.batchUpdateEnableStatus(slotIds, 1);
        }
        this.slotCacheService.updateBatchSlotCache(slotIds);
        return true;
    }

    @Override
    public List<SlotDto> getListDetail(List<Long> slotIds) throws TuiaMediaException {
        return this.slotDAO.selectListDetail(slotIds);
    }

    @Override
    public List<Long> selectIdsByName(String slotName) throws TuiaMediaException {
        return this.slotDAO.selectIdsByName(slotName);
    }

    @Override
    public List<IdAndName> selectAppIdAndName(List<Long> slotIds) throws TuiaMediaException {
        return this.slotDAO.selectAppIdAndName(slotIds);
    }

    @Override
    public Boolean updateSlot(SlotDto slotDto) throws TuiaMediaException {
        this.slotDAO.update(slotDto);
        this.slotCacheService.updateSlotCache(slotDto.getId());
        return true;
    }

    @Override
    public Boolean closeSlotByMsId(Long msId) throws TuiaMediaException {
        this.slotDAO.closeSlotByMsId(msId);
        List<Long> ids = this.slotDAO.getIdsByMsId(msId);
        this.slotCacheService.updateBatchSlotCache(ids);
        return true;
    }
}

