/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.SlotTypeParamDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqUpdateSlot;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMaterialSpecificationDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDetailDto;
import cn.com.duiba.tuia.media.bo.SlotBackendBo;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.req.ReqCreateSlot;
import cn.com.duiba.tuia.media.model.req.ReqEditSlotEnableStatus;
import cn.com.duiba.tuia.media.model.req.ReqSlotList;
import cn.com.duiba.tuia.media.model.rsp.RspPageResult;
import cn.com.duiba.tuia.media.model.rsp.RspSlot;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.MediaAppMsService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.utils.RequestLocal;
import cn.com.duiba.tuia.media.web.aop.LogWrite;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/slot"})
@Api(value="\u5e7f\u544a\u4f4d\u76f8\u5173\u63a5\u53e3")
public class SlotController
extends BaseController {
    @Autowired
    private SlotService slotService;
    @Autowired
    private SlotBackendBo slotBackendBo;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private MediaAppMsService mediaAppMsService;

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u521b\u5efa\u5e7f\u544a\u4f4d")
    @ResponseBody
    @ApiOperation(value="\u521b\u5efa\u5e7f\u544a\u4f4d", httpMethod="POST", notes="\u521b\u5efa\u5e7f\u544a\u4f4d\u63a5\u53e3")
    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Result<Boolean> createSlot(@Valid @RequestBody ReqCreateSlot req, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            req.setMediaId(rl.getCid());
            this.checkSlotType(req);
            return this.successResult(this.slotService.insert(req));
        }
        catch (Exception e) {
            this.logger.error("SlotController.createSlot error! the param=[{}]", (Object)req);
            return this.failResult(e);
        }
    }

    private void checkSlotType(ReqCreateSlot req) throws TuiaMediaException {
        if (9 == req.getSlotType()) {
            if (req.getMsId() == null) {
                throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u975e\u624b\u52a8\u6295\u653e\u7c7b\u578b\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else if (8 != req.getSlotType()) {
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u5e7f\u544a\u4f4d\u7c7b\u578b\u672a\u77e5");
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5217\u8868")
    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public Result<RspPageResult<RspSlot>> getList(@ModelAttribute ReqSlotList param) {
        try {
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            param.setPageSize(Integer.valueOf(50));
            param.setRowStart((param.getCurrentPage() - 1) * param.getPageSize());
            return this.successResult(this.slotService.selectListByPage(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.getList error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u5e7f\u544a\u4f4d\u8be6\u60c5", httpMethod="GET", notes="\u67e5\u770b\u5e7f\u544a\u4f4d\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParam(name="slotId", value="\u5e7f\u544a\u4f4dID", required=true, dataType="Long", paramType="query")
    @ResponseBody
    @RequestMapping(value={"/getDetail"})
    public Result<RspSlotDetailDto> getDetail(@RequestParam Long slotId) {
        try {
            if (slotId == null) {
                this.logger.error("slotIds can not be null");
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            return this.successResult(this.slotBackendBo.getSlotDetailById(slotId));
        }
        catch (Exception e) {
            this.logger.error("slotController getDetail error! the slotId=[{}]", (Object)slotId);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u7f16\u8f91\u5e7f\u544a\u4f4d")
    @ResponseBody
    @ApiOperation(value="\u7f16\u8f91\u5e7f\u544a\u4f4d", httpMethod="POST", notes="\u7f16\u8f91\u5e7f\u544a\u4f4d")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Result<Boolean> update(@Valid @RequestBody ReqUpdateSlot param, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            return this.successResult(this.slotService.update(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.update error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @LogWrite(modelName="\u5e7f\u544a\u4f4d\u6a21\u5757", option="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed")
    @ResponseBody
    @ApiOperation(value="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed", httpMethod="POST", notes="\u5e7f\u544a\u4f4d\u5f00\u542f/\u5173\u95ed")
    @RequestMapping(value={"/updateEnableStatus"}, method={RequestMethod.POST})
    public Result<Boolean> updateEnableStatus(@Valid @RequestBody ReqEditSlotEnableStatus param, BindingResult result) {
        try {
            this.checkParam(result);
            RequestLocal rl = RequestLocal.get();
            param.setMediaId(rl.getCid());
            return this.successResult(this.slotService.updateEnableStatus(param));
        }
        catch (Exception e) {
            this.logger.error("SlotController.updateEnableStatus error! the param=[{}]", (Object)param);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u7c7b\u578b\u53c2\u6570", httpMethod="GET", notes="\u67e5\u8be2\u5e7f\u544a\u7c7b\u578b\u53c2\u6570")
    @RequestMapping(value={"/getSlotTypeParam"}, method={RequestMethod.GET})
    public Result<List<SlotTypeParamDto>> getSlotTypeParam() {
        try {
            ArrayList<SlotTypeParamDto> result = new ArrayList<SlotTypeParamDto>();
            SlotTypeParamDto manual = new SlotTypeParamDto();
            manual.setTypeCode(Integer.valueOf(8));
            manual.setSlotType("\u624b\u52a8\u6295\u653e");
            result.add(manual);
            SlotTypeParamDto notManual = new SlotTypeParamDto();
            notManual.setTypeCode(Integer.valueOf(9));
            notManual.setSlotType("\u975e\u624b\u52a8\u6295\u653e");
            result.add(notManual);
            return this.successResult(result);
        }
        catch (Exception e) {
            this.logger.error("SlotController.getSlotTypeParam error!");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u67e5\u8be2\u89c4\u683c\u5217\u8868", httpMethod="GET", notes="\u67e5\u8be2\u89c4\u683c\u5217\u8868")
    @RequestMapping(value={"/getMsListByMediaId"}, method={RequestMethod.GET})
    public Result<List<RspMaterialSpecificationDto>> getMsListByMediaId(@RequestParam Long id) {
        try {
            ReqMaterialSpecificationDto req = new ReqMaterialSpecificationDto();
            req.setSort("gmt_modified");
            req.setOrder("desc");
            req.setPageSize(Integer.valueOf(-1));
            List list = this.materialSpecificationService.getMaterialSpecificationList(req);
            Iterator iterator = list.iterator();
            List exceptMsIds = this.mediaAppMsService.getMsIdsExceptTheMediaApp(id);
            List msIds = this.mediaAppMsService.getMsIdsByMediaApp(id);
            if (!CollectionUtils.isEmpty((Collection)exceptMsIds)) {
                while (iterator.hasNext()) {
                    Long msId = ((RspMaterialSpecificationDto)iterator.next()).getId();
                    if (!CollectionUtils.isEmpty((Collection)msIds) && msIds.contains(msId) || !exceptMsIds.contains(msId)) continue;
                    iterator.remove();
                }
            }
            return this.successResult(list);
        }
        catch (Exception e) {
            this.logger.error("SlotController.getMsListByMediaId error!");
            return this.failResult(e);
        }
    }
}

