/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.tool.IDGeneratorTool;
import cn.com.duiba.tuia.media.common.tool.UploadTool;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.model.rsp.UploadRsp;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Controller
@RequestMapping(value={"/upload"})
@Api(value="\u6587\u4ef6\u4e0a\u4f20api")
public class UploadController
extends BaseController {
    @ApiOperation(value="\u4e0a\u4f20\u8425\u4e1a\u7167", httpMethod="POST", notes="\u4e0a\u4f20\u8425\u4e1a\u7167\u63a5\u53e3")
    @ResponseBody
    @RequestMapping(value={"/index"}, method={RequestMethod.POST})
    public Result<UploadRsp> upload(HttpServletRequest request, HttpServletResponse response) {
        try {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (!multipartResolver.isMultipart(request)) {
                throw new TuiaMediaException(ErrorCode.E9999999);
            }
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            MultipartFile mf = multipartRequest.getFile("file");
            if (mf == null) {
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            String fileName = mf.getOriginalFilename();
            String fileType = fileName.substring(fileName.lastIndexOf(46) + 1);
            if ("jpg".equalsIgnoreCase(fileType) || "jpeg".equalsIgnoreCase(fileType) || "png".equalsIgnoreCase(fileType) || "gif".equalsIgnoreCase(fileType)) {
                String name = IDGeneratorTool.getRandomString((int)10) + "." + fileType;
                String path = "tuia-media/img/" + name;
                long size = mf.getSize();
                InputStream inputStream = mf.getInputStream();
                UploadTool.uploadOssImg((InputStream)inputStream, (String)path, (long)size);
                UploadRsp rsp = new UploadRsp();
                rsp.setFileName(fileName);
                rsp.setUrl(UploadTool.getTuiaUrl() + path);
                return this.successResult(rsp);
            }
            this.logger.error("not supported [{}] file type", (Object)fileType);
            throw new TuiaMediaException(ErrorCode.E0002005);
        }
        catch (Exception e) {
            this.logger.error("upload error!");
            return this.failResult(e);
        }
    }
}

