/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.tdc;

import com.taobao.api.ApiException;
import com.taobao.api.internal.tdc.CsvTdcResponse;
import com.taobao.api.internal.tdc.JXTdcResponse;
import com.taobao.api.internal.tdc.TdcClient;
import com.taobao.api.internal.tdc.TdcReflowRequest;
import com.taobao.api.internal.tdc.TdcRequest;
import com.taobao.api.internal.tdc.TdcResponse;
import com.taobao.api.internal.tdc.parser.TdcCsvParser;
import com.taobao.api.internal.tdc.parser.TdcJsonParser;
import com.taobao.api.internal.tdc.parser.TdcMbpBackParser;
import com.taobao.api.internal.tdc.parser.TdcParser;
import com.taobao.api.internal.tdc.parser.TdcXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class DefaultTdcClient
implements TdcClient {
    private static final String APP_KEY = "app_key";
    private static final String FORMAT = "format";
    private static final String TIMESTAMP = "timestamp";
    private static final String SIGN = "sign";
    private static final String SIGN_METHOD = "sign_method";
    private static final String PARTNER_ID = "partner_id";
    private static final String SESSION = "session";
    private static final String PATH_INFO = "path_info";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String signMethod = "md5";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private boolean needEnableParser = true;

    public DefaultTdcClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultTdcClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultTdcClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    public CsvTdcResponse csvExecute(TdcRequest request) throws ApiException {
        return this.csvExecute(request, null);
    }

    public CsvTdcResponse csvExecute(TdcRequest request, String session) throws ApiException {
        TdcCsvParser parser = null;
        if (this.needEnableParser) {
            parser = new TdcCsvParser();
        }
        return (CsvTdcResponse)this._execute(request, session, parser, "csv");
    }

    public JXTdcResponse jsonExecute(TdcRequest request) throws ApiException {
        return this.jsonExecute(request, null);
    }

    public JXTdcResponse jsonExecute(TdcRequest request, String session) throws ApiException {
        TdcJsonParser parser = null;
        if (this.needEnableParser) {
            parser = new TdcJsonParser();
        }
        return (JXTdcResponse)this._execute(request, session, parser, "json");
    }

    public JXTdcResponse xmlExecute(TdcRequest request) throws ApiException {
        return this.xmlExecute(request, null);
    }

    public JXTdcResponse xmlExecute(TdcRequest request, String session) throws ApiException {
        TdcXmlParser parser = null;
        if (this.needEnableParser) {
            parser = new TdcXmlParser();
        }
        return (JXTdcResponse)this._execute(request, session, parser, "xml");
    }

    private TdcResponse _execute(TdcRequest request, String session, TdcParser parser, String format) throws ApiException {
        TdcResponse tdcRsp = null;
        String rsp = this.doPost(request, session, format);
        if (this.needEnableParser) {
            tdcRsp = parser.parse(rsp);
        } else {
            tdcRsp = new TdcResponse();
            tdcRsp.setBody(rsp);
        }
        return tdcRsp;
    }

    private String doPost(TdcRequest request, String session, String format) throws ApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = request.getParams();
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put(APP_KEY, this.appKey);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put(TIMESTAMP, df.format(new Date(timestamp)));
        protocalMustParams.put(PATH_INFO, request.getPathInfo());
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put(FORMAT, format);
        protocalOptParams.put(SIGN_METHOD, this.signMethod);
        protocalOptParams.put(SESSION, session);
        protocalOptParams.put(PARTNER_ID, "top-sdk-java-20141128");
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if ("md5".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, false));
            } else if ("hmac".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, true));
            } else {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequest(requestHolder, this.appSecret));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        protocalMustParams.remove(PATH_INFO);
        StringBuffer urlSb = new StringBuffer(this.serverUrl + request.getPathInfo());
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            rsp = WebUtils.doPost(urlSb.toString(), (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.setNeedEnableLogger(needEnableLogger);
    }

    public TdcResponse execute(TdcReflowRequest request, String session) throws ApiException {
        String rsp = this.doBackflowPost(request, session, "json");
        TdcMbpBackParser parser = new TdcMbpBackParser();
        return parser.parse(rsp);
    }

    private String doBackflowPost(TdcReflowRequest request, String session, String format) throws ApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = request.getParams();
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put(APP_KEY, this.appKey);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put(TIMESTAMP, df.format(new Date(timestamp)));
        protocalMustParams.put(PATH_INFO, request.getPathInfo());
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put(FORMAT, format);
        protocalOptParams.put(SIGN_METHOD, this.signMethod);
        protocalOptParams.put(SESSION, session);
        protocalOptParams.put(PARTNER_ID, "top-sdk-java-20141128");
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if ("md5".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, false));
            } else if ("hmac".equals(this.signMethod)) {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequestNew(requestHolder, this.appSecret, true));
            } else {
                protocalMustParams.put(SIGN, TaobaoUtils.signTopRequest(requestHolder, this.appSecret));
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        protocalMustParams.remove(PATH_INFO);
        StringBuffer urlSb = new StringBuffer(this.serverUrl + request.getPathInfo());
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        String rsp = null;
        try {
            rsp = WebUtils.doPost(urlSb.toString(), (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        return rsp;
    }
}

