/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.embedded;

import com.taobao.top.link.Logger;
import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ClientChannel;
import com.taobao.top.link.channel.embedded.EmbeddedWebSocketClientChannel;
import com.taobao.top.link.channel.embedded.EmbeddedWebSocketHandler;
import com.taobao.top.link.channel.websocket.WebSocketClientHelper;
import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.WebSockets;
import com.taobao.top.link.embedded.websocket.impl.WebSocketBase;
import com.taobao.top.link.embedded.websocket.impl.WebSocketImpl;
import java.net.URI;
import java.util.Map;

public class EmbeddedWebSocketClient {
    private static final String[] subprotocol = new String[0];

    public static ClientChannel connect(LoggerFactory loggerFactory, URI uri, int timeout) throws ChannelException {
        EmbeddedWebSocketClient.resetSettings();
        Logger logger = loggerFactory.create(String.format("EmbeddedWebSocketHandler-%s", uri));
        EmbeddedWebSocketClientChannel clientChannel = new EmbeddedWebSocketClientChannel();
        clientChannel.setUri(uri);
        try {
            WebSocket socket = WebSockets.create(uri.toASCIIString(), new EmbeddedWebSocketHandler(logger, clientChannel), subprotocol);
            ((WebSocketBase)socket).setPacketDumpMode(0);
            socket.setBlockingMode(false);
            socket.setConnectionTimeout(timeout / 1000);
            Map<String, String> headers = WebSocketClientHelper.getHeaders(uri);
            if (headers != null) {
                for (String h : headers.keySet()) {
                    ((WebSocketImpl)socket).getRequestHeader().addHeader(h, headers.get(h));
                }
            }
            socket.connect();
        }
        catch (Exception e) {
            throw new ChannelException(Text.CONNECT_ERROR, e);
        }
        if (clientChannel.error != null) {
            throw new ChannelException(Text.WS_HANDSHAKE_ERROR, clientChannel.error);
        }
        return clientChannel;
    }

    private static void resetSettings() {
        System.setProperty("websocket.upstreamQueueSize", "10000");
        System.setProperty("websocket.packatdump", "0");
    }
}

