/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.websocket;

import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelHandler;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.netty.NettyServerUpstreamHandler;
import com.taobao.top.link.channel.websocket.CustomWebSocket13FrameDecoder;
import com.taobao.top.link.channel.websocket.WebSocketServerChannelSender;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketServerUpstreamHandler
extends NettyServerUpstreamHandler {
    private WebSocketServerHandshaker handshaker;
    private boolean cumulative;

    public WebSocketServerUpstreamHandler(LoggerFactory loggerFactory, ChannelHandler channelHandler, ChannelGroup channelGroup, boolean cumulative) {
        super(loggerFactory, channelHandler, channelGroup);
        this.cumulative = cumulative;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else if (msg instanceof List) {
            this.handleWebSocketFrame(ctx, (List)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        this.dump(req);
        if (req.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        this.renderServerChannelContext(req);
        if (this.channelHandler != null) {
            try {
                this.channelHandler.onConnect(this.createContext(req.getHeaders()));
            }
            catch (Exception e) {
                this.logger.error(e);
                this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(401, e.getMessage())));
                return;
            }
        }
        String subprotocols = null;
        boolean allowExtensions = false;
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.getUri(), subprotocols, allowExtensions);
        this.handshaker = wsFactory.newHandshaker(req);
        if (this.handshaker == null) {
            wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
            return;
        }
        this.handshaker.handshake(ctx.getChannel(), req).addListener(WebSocketServerHandshaker.HANDSHAKE_LISTENER);
        if (this.cumulative) {
            ctx.getPipeline().replace(WebSocket13FrameDecoder.class, "wsdecoder-custom", (org.jboss.netty.channel.ChannelHandler)new CustomWebSocket13FrameDecoder(true, allowExtensions, this.handshaker.getMaxFramePayloadLength()));
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            Object[] objectArray = new Object[2];
            objectArray[0] = ((CloseWebSocketFrame)frame).getStatusCode();
            this.closedReason = ((CloseWebSocketFrame)frame).getReasonText();
            objectArray[1] = this.closedReason;
            this.logger.info(Text.WS_CONNECTION_CLOSED_BY, objectArray);
            ctx.getChannel().close();
            return;
        }
        if (frame instanceof BinaryWebSocketFrame) {
            if (!((BinaryWebSocketFrame)frame).isFinalFragment()) {
                this.logger.warn(Text.WS_NOT_FINAL);
                return;
            }
            if (this.channelHandler != null) {
                ChannelBuffer buffer = ((BinaryWebSocketFrame)frame).getBinaryData();
                this.channelHandler.onMessage(this.createContext(buffer.toByteBuffer()));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unhandled frame: %s", frame);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, List<WebSocketFrame> frames) throws Exception {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (WebSocketFrame f : frames) {
            buffers.add(f.getBinaryData().toByteBuffer());
        }
        this.channelHandler.onMessage(this.createContext(buffers));
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void dump(HttpRequest request) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug(request.getMethod().getName());
        this.logger.debug(request.getUri());
        for (Map.Entry h : request.getHeaders()) {
            this.logger.debug("%s=%s", h.getKey(), h.getValue());
        }
    }

    private void renderServerChannelContext(HttpRequest request) {
        WebSocketServerChannelSender serverChannelSender = (WebSocketServerChannelSender)this.sender;
        for (Map.Entry h : request.getHeaders()) {
            serverChannelSender.setContext(h.getKey(), h.getValue());
        }
    }

    @Override
    protected ChannelSender createSender(Channel channel) {
        return new WebSocketServerChannelSender(channel);
    }
}

