/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.constants;

public enum SlotPictureSizeEnmu {
    SIZE_0(0, 700, 280),
    SIZE_1(1, 225, 140),
    SIZE_2(2, 600, 270),
    SIZE_3(3, 640, 960),
    SIZE_4(4, 800, 120),
    SIZE_5(5, 140, 140),
    SIZE_6(6, 1280, 720),
    SIZE_21(21, 150, 150),
    SIZE_41(41, 510, 510),
    SIZE_42(42, 510, 510),
    SIZE_61(61, 640, 150),
    SIZE_81(81, 640, 280),
    SIZE_91(91, 750, 1334),
    SIZE_92(92, 600, 300),
    SIZE_93(93, 640, 960),
    SIZE_94(94, 720, 1000),
    SIZE_95(95, 345, 415);

    private int sizeId;
    private int width;
    private int height;

    private SlotPictureSizeEnmu(int sizeId, int width, int height) {
        this.sizeId = sizeId;
        this.width = width;
        this.height = height;
    }

    public int getSizeId() {
        return this.sizeId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static PictureSize getPictureSizeById(int sizeId) {
        SlotPictureSizeEnmu[] values;
        for (SlotPictureSizeEnmu value : values = SlotPictureSizeEnmu.values()) {
            if (sizeId != value.getSizeId()) continue;
            return new PictureSize(value.getWidth(), value.getHeight());
        }
        return null;
    }

    public static String getPictureSizeStr(int sizeId) {
        PictureSize pictureSize = SlotPictureSizeEnmu.getPictureSizeById(sizeId);
        String pictureSizeStr = "";
        if (pictureSize != null) {
            StringBuilder buildStr = new StringBuilder();
            pictureSizeStr = buildStr.append(pictureSize.getWidth()).append("*").append(pictureSize.getHeight()).toString();
            if ("*".equals(pictureSizeStr)) {
                return "";
            }
            return pictureSizeStr;
        }
        return pictureSizeStr;
    }

    public static class PictureSize {
        private int width;
        private int height;

        public PictureSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public PictureSize() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

