/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.JsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxUtils {
    private static Logger logger = LoggerFactory.getLogger(AjaxUtils.class);
    private static final String HEADER_ENCODING = "encoding";
    private static final String HEADER_NOCACHE = "no-cache";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final boolean DEFAULT_NOCACHE = true;
    public static final ObjectMapper MAPPER = JsonUtils.mapper;
    private AjaxUtils au;

    public AjaxUtils getAjaxUtils() {
        if (this.au == null) {
            this.au = new AjaxUtils();
        }
        return this.au;
    }

    public static void render(HttpServletResponse response, String contentType, String content, String ... headers) throws TuiaMediaException {
        AjaxUtils.initResponseHeader(response, contentType, headers);
        try (PrintWriter write = null;){
            write = response.getWriter();
            write.write(content);
            write.flush();
        }
    }

    public static void renderText(HttpServletResponse response, String text, String ... headers) throws TuiaMediaException {
        AjaxUtils.render(response, "text/plain", text, headers);
    }

    public static void renderHtml(HttpServletResponse response, String html, String ... headers) throws TuiaMediaException {
        AjaxUtils.render(response, "text/html", html, headers);
    }

    public static void renderXml(HttpServletResponse response, String xml, String ... headers) throws TuiaMediaException {
        AjaxUtils.render(response, "text/xml", xml, headers);
    }

    public static void renderJson(HttpServletResponse response, String jsonString, String ... headers) throws TuiaMediaException {
        AjaxUtils.render(response, "application/json", jsonString, headers);
    }

    public static void renderJson(HttpServletResponse response, Object data, String ... headers) {
        AjaxUtils.initResponseHeader(response, "application/json", headers);
        try {
            MAPPER.writeValue((Writer)response.getWriter(), data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void renderJsonp(HttpServletResponse response, String callbackName, Object object, String ... headers) throws TuiaMediaException {
        String jsonString = null;
        try {
            jsonString = MAPPER.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        String result = callbackName + "(" + jsonString + ");";
        AjaxUtils.render(response, "text/javascript", result, headers);
    }

    private static void initResponseHeader(HttpServletResponse response, String contentType, String ... headers) {
        String encoding = DEFAULT_ENCODING;
        boolean noCache = true;
        for (String header : headers) {
            String headerName = StringUtils.substringBefore((String)header, (String)":");
            String headerValue = StringUtils.substringAfter((String)header, (String)":");
            if (StringUtils.equalsIgnoreCase((String)headerName, (String)HEADER_ENCODING)) {
                encoding = headerValue;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)headerName, (String)HEADER_NOCACHE)) {
                noCache = Boolean.parseBoolean(headerValue);
                continue;
            }
            throw new IllegalArgumentException(headerName + "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684header\u7c7b\u578b");
        }
        String fullContentType = contentType + ";charset=" + encoding;
        response.setContentType(fullContentType);
        if (noCache) {
            AjaxUtils.setDisableCacheHeader(response);
        }
    }

    public static void setDisableCacheHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", 1L);
        response.addHeader("Pragma", HEADER_NOCACHE);
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0");
    }

    public static void renderJsonporJson(HttpServletResponse response, String callbackName, Object object, String ... headers) throws TuiaMediaException {
        if (callbackName != null && !"".equals(callbackName)) {
            AjaxUtils.renderJsonp(response, callbackName, object, headers);
        } else {
            AjaxUtils.renderJson(response, object, headers);
        }
    }

    public static void renderJsonporJson2(HttpServletResponse response, String callbackName, String data, String ... headers) throws TuiaMediaException {
        if (callbackName != null && !"".equals(callbackName)) {
            String result = callbackName + "(" + data + ")";
            AjaxUtils.renderText(response, result, headers);
        } else {
            AjaxUtils.renderJson(response, data, headers);
        }
    }

    static {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }
}

