/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.SignatureArithmeticUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureUtils {
    private static Logger logger = LoggerFactory.getLogger(SignatureUtils.class);
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final String ENCRYPTION_ALGORITHM = "SHA-1";
    private static final boolean DEFAULT_PUB = true;

    private SignatureUtils() {
    }

    public static String toHex(byte[] data) {
        return new String(Hex.encode((byte[])data));
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToBytes(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String digest(String strSrc) throws TuiaMediaException {
        return SignatureUtils.digest(strSrc, true);
    }

    public static String digest(String strSrc, boolean pub) throws TuiaMediaException {
        return SignatureUtils.digest(strSrc, "MD5", pub);
    }

    public static String digest(String strSrc, String encName) throws TuiaMediaException {
        return SignatureUtils.digest(strSrc, encName, true);
    }

    public static String digest(String strSrc, String encName, boolean pub) throws TuiaMediaException {
        MessageDigest md = null;
        String strDes = null;
        String eName = encName;
        byte[] bt = strSrc.getBytes();
        try {
            if (eName.isEmpty()) {
                eName = "MD5";
            }
            md = MessageDigest.getInstance(eName);
            md.update(bt);
            byte[] digest = md.digest();
            strDes = pub ? SignatureUtils.toHex(digest) : SignatureUtils.bytesToHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(" SignatureUtils digest is error , the e = [{}]", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002003);
        }
        return strDes;
    }

    public static String signature(String appId, String key, String digest, long millis) throws TuiaMediaException {
        return SignatureUtils.signature(appId, key, digest, millis, true);
    }

    public static String signature(String appId, String key, String digest, long millis, boolean pub) throws TuiaMediaException {
        String timestamp = String.valueOf(millis);
        String signature = null;
        if (SignatureUtils.isNotBlank(key) && SignatureUtils.isNotBlank(timestamp) && SignatureUtils.isNotBlank(appId)) {
            String value = SignatureArithmeticUtils.get(appId, key, digest, String.valueOf(millis));
            signature = SignatureUtils.digest(value, ENCRYPTION_ALGORITHM, pub);
        }
        return signature;
    }

    public static boolean isValidate(String signature, String appId, String secretKey, String digest, long millis) throws TuiaMediaException {
        return SignatureUtils.isValidate(signature, appId, secretKey, digest, millis, true);
    }

    public static boolean isValidate(String signature, String appId, String secretKey, String digest, long millis, boolean pub) throws TuiaMediaException {
        String calculatedSignature = SignatureUtils.signature(appId, secretKey, digest, millis, pub);
        return SignatureUtils.isBlank(calculatedSignature) ? false : calculatedSignature.equals(signature);
    }

    public static boolean isNotBlank(String str) {
        return !SignatureUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

