/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.ons;

import cn.com.duiba.boot.ext.autoconfigure.ons.OnsProperties;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={OnsProperties.class})
public class OnsAutoConfiguration {

    private static class OnsConsumerFactoryBean
    implements FactoryBean<Consumer>,
    InitializingBean {
        @Resource(name="bootOnsMessageListener", type=MessageListener.class)
        private MessageListener onsMessageListener;
        private Consumer onsConsumer;
        private OnsProperties onsProperties;

        public OnsConsumerFactoryBean(OnsProperties onsProperties) {
            this.onsProperties = onsProperties;
        }

        public void afterPropertiesSet() throws Exception {
            String[] topicArr;
            Properties properties = new Properties();
            properties.put("ConsumerId", this.onsProperties.getConsumer().getGroup());
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("maxReconsumeTimes", this.onsProperties.getConsumer().getMaxReconsumeTimes());
            if (this.onsProperties.getConsumer().getConsumeThreadNums() > 0) {
                properties.put("ConsumeThreadNums", this.onsProperties.getConsumer().getConsumeThreadNums());
            }
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            String topics = this.onsProperties.getConsumer().getTopics();
            for (String topic : topicArr = topics.split(",")) {
                consumer.subscribe(topic, "*", this.onsMessageListener);
            }
            consumer.start();
            this.onsConsumer = consumer;
        }

        public Consumer getObject() throws Exception {
            return this.onsConsumer;
        }

        public Class<?> getObjectType() {
            return Consumer.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Consumer.class})
    @ConditionalOnMissingBean(name={"onsConsumer"})
    @ConditionalOnProperty(name={"duiba.ons.consumer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsConsumerConfigurator
    extends OnsClientConfiguration {
        protected OnsConsumerConfigurator() {
        }

        @Bean(name={"onsConsumer"})
        public FactoryBean<Consumer> onsConsumer() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            return new OnsConsumerFactoryBean(this.onsProperties);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Producer.class})
    @ConditionalOnMissingBean(name={"onsProducer"})
    @ConditionalOnProperty(name={"duiba.ons.producer.enable"}, havingValue="true", matchIfMissing=false)
    protected static class OnsProducerConfigurator
    extends OnsClientConfiguration {
        protected OnsProducerConfigurator() {
        }

        @Bean(name={"onsProducer"}, destroyMethod="shutdown")
        public Producer onsProducer() {
            Properties properties = new Properties();
            properties.put("ProducerId", "PID-hwq-trade-center");
            properties.put("AccessKey", this.onsProperties.getAccessKey());
            properties.put("SecretKey", this.onsProperties.getSecretKey());
            properties.put("SendMsgTimeoutMillis", this.onsProperties.getProducer().getSendMsgTimeoutMillis());
            Producer producer = ONSFactory.createProducer((Properties)properties);
            producer.start();
            return producer;
        }
    }

    protected static abstract class OnsClientConfiguration {
        @Autowired
        protected OnsProperties onsProperties;

        protected OnsClientConfiguration() {
        }
    }
}

