/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.undertow;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentManager;
import java.lang.reflect.Field;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class UndertowEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(UndertowEmbeddedServletContainer.class);
    private final Undertow.Builder builder;
    private final DeploymentManager manager;
    private final String contextPath;
    private final int port;
    private final boolean autoStart;
    private Undertow undertow;
    private boolean started = false;

    public UndertowEmbeddedServletContainer(Undertow.Builder builder, DeploymentManager manager, String contextPath, int port, boolean autoStart) {
        this.builder = builder;
        this.manager = manager;
        this.contextPath = contextPath;
        this.port = port;
        this.autoStart = autoStart;
    }

    @Override
    public synchronized void start() throws EmbeddedServletContainerException {
        if (!this.autoStart) {
            return;
        }
        if (this.undertow == null) {
            this.undertow = this.createUndertowServer();
        }
        this.undertow.start();
        this.started = true;
        logger.info((Object)("Undertow started on port(s) " + this.getPortsDescription()));
    }

    private Undertow createUndertowServer() {
        try {
            HttpHandler servletHandler = this.manager.start();
            this.builder.setHandler(this.getContextHandler(servletHandler));
            return this.builder.build();
        }
        catch (ServletException ex) {
            throw new EmbeddedServletContainerException("Unable to start embdedded Undertow", ex);
        }
    }

    private HttpHandler getContextHandler(HttpHandler servletHandler) {
        if (StringUtils.isEmpty((Object)this.contextPath)) {
            return servletHandler;
        }
        return Handlers.path().addPrefixPath(this.contextPath, servletHandler);
    }

    private String getPortsDescription() {
        try {
            Field listenersField = ReflectionUtils.findField(Undertow.class, (String)"listeners");
            listenersField.setAccessible(true);
            List listeners = (List)listenersField.get(this.undertow);
            StringBuilder ports = new StringBuilder();
            for (Object listener : listeners) {
                Field portField = ReflectionUtils.findField(listener.getClass(), (String)"port");
                portField.setAccessible(true);
                Field typeField = ReflectionUtils.findField(listener.getClass(), (String)"type");
                typeField.setAccessible(true);
                ports.append(ports.length() == 0 ? "" : ", ");
                ports.append(portField.get(listener) + " (" + typeField.get(listener).toString().toLowerCase() + ")");
            }
            return ports.toString();
        }
        catch (Exception exception) {
            return String.valueOf(this.port);
        }
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        if (this.started) {
            this.started = false;
            this.undertow.stop();
        }
    }

    @Override
    public int getPort() {
        return this.port;
    }
}

