/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public abstract class EnvironmentTestUtils {
    public static void addEnvironment(ConfigurableApplicationContext context, String ... pairs) {
        EnvironmentTestUtils.addEnvironment(context.getEnvironment(), pairs);
    }

    public static void addEnvironment(ConfigurableEnvironment environment, String ... pairs) {
        EnvironmentTestUtils.addEnvironment("test", environment, pairs);
    }

    public static void addEnvironment(String name, ConfigurableEnvironment environment, String ... pairs) {
        Map<String, String> map;
        MutablePropertySources sources = environment.getPropertySources();
        if (!sources.contains(name)) {
            map = new HashMap();
            MapPropertySource source = new MapPropertySource(name, map);
            sources.addFirst((PropertySource)source);
        } else {
            Map value = (Map)sources.get(name).getSource();
            map = value;
        }
        for (String pair : pairs) {
            int index = pair.indexOf(":");
            index = index < 0 ? (index = pair.indexOf("=")) : index;
            String key = pair.substring(0, index > 0 ? index : pair.length());
            String value = index > 0 ? pair.substring(index + 1) : "";
            map.put(key.trim(), value.trim());
        }
    }
}

