/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = -7589512013334920693L;
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;

    public StringArrayDeserializer() {
        super(String[].class);
        this._elementDeserializer = null;
    }

    protected StringArrayDeserializer(JsonDeserializer<?> jsonDeserializer) {
        super(String[].class);
        this._elementDeserializer = jsonDeserializer;
    }

    @Override
    public String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        Object object;
        JsonToken jsonToken;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            object = jsonToken == JsonToken.VALUE_STRING ? jsonParser.getText() : (jsonToken == JsonToken.VALUE_NULL ? null : this._parseString(jsonParser, deserializationContext));
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = object;
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected final String[] _deserializeCustom(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String[] stringArray;
        JsonToken jsonToken;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        JsonDeserializer<String> jsonDeserializer = this._elementDeserializer;
        int n = 0;
        while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            Object object = stringArray = jsonToken == JsonToken.VALUE_NULL ? null : jsonDeserializer.deserialize(jsonParser, deserializationContext);
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = stringArray;
        }
        stringArray = objectBuffer.completeAndClearBuffer(objectArray, n, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return stringArray;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final String[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            String string;
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string = jsonParser.getText()).length() == 0) {
                return null;
            }
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new String[]{jsonParser.getCurrentToken() == JsonToken.VALUE_NULL ? null : this._parseString(jsonParser, deserializationContext)};
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        if ((jsonDeserializer = (jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer)) == null ? deserializationContext.findContextualValueDeserializer(deserializationContext.constructType(String.class), beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty)) != null && this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        if (this._elementDeserializer != jsonDeserializer) {
            return new StringArrayDeserializer(jsonDeserializer);
        }
        return this;
    }
}

