/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityManualPlanDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityManualPlanDO;
import cn.com.duiba.tuia.media.service.ActivityManualService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityManualServiceImpl
implements ActivityManualService {
    @Autowired
    private ActivityManualPlanDAO activityManualPlanDAO;

    @Override
    public boolean addActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.insert(manualPlan);
    }

    @Override
    public ActivityManualPlanDO findActivityManualPlan(Long slotId) throws TuiaMediaException {
        ActivityManualPlanDO releasePlan = null;
        long currentTime = System.currentTimeMillis();
        List<ActivityManualPlanDO> planList = this.findActivityManualPlans(slotId);
        for (ActivityManualPlanDO plan : planList) {
            if (1 == plan.getStatus()) {
                releasePlan = plan;
            }
            if (0 != plan.getStatus() || currentTime < plan.getReleaseTime().getTime()) continue;
            if (releasePlan != null) {
                this.activityManualPlanDAO.updateStatusBefore(releasePlan, 2);
            }
            plan.setStatus(1);
            this.activityManualPlanDAO.updateStatus(plan, 1);
            return plan;
        }
        return releasePlan;
    }

    @Override
    public List<ActivityManualPlanDO> findActivityManualPlans(Long slotId) throws TuiaMediaException {
        return this.activityManualPlanDAO.selectForList(slotId);
    }

    @Override
    public boolean removeActivityManualPlan(ActivityManualPlanDO manualPlan) throws TuiaMediaException {
        return this.activityManualPlanDAO.delete(manualPlan);
    }
}

