/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.utils;

import cn.com.duiba.tuia.media.common.tool.SecureTool;
import cn.com.duiba.tuia.media.utils.CookieUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLocal {
    private Logger logger = LoggerFactory.getLogger(RequestLocal.class);
    private static final int DAY_OF_MILLISECOND = 86400000;
    private static ThreadLocal<RequestLocal> local = new ThreadLocal();
    private Long cid;
    private JSONObject accountInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;

    private RequestLocal() {
    }

    public static RequestLocal get() {
        RequestLocal rl = local.get();
        if (rl == null) {
            rl = new RequestLocal();
            local.set(rl);
        }
        return rl;
    }

    public static void clear() {
        local.set(null);
    }

    private String getCookie(String key) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String value;
                if (!key.equals(cookie.getName()) || !StringUtils.isNotBlank((String)(value = cookie.getValue()))) continue;
                return value;
            }
        }
        return null;
    }

    public JSONObject getAccountInfo() {
        if (this.accountInfo == null) {
            try {
                String content;
                String accound = this.getCookie("dataxyz345");
                if (accound != null && StringUtils.isNotBlank((String)(content = SecureTool.decryptConsumerCookie((String)accound)))) {
                    JSONObject json = JSON.parseObject((String)content);
                    if (new Date().getTime() - json.getLong("loginTime") < 86400000L) {
                        this.accountInfo = json;
                    } else {
                        CookieUtil.deleteCookie("dataxyz345");
                    }
                }
            }
            catch (Exception e) {
                CookieUtil.deleteCookie("dataxyz345");
                this.logger.error("parse cookie happen error", (Throwable)e);
            }
        }
        return this.accountInfo;
    }

    public Long getCid() {
        if (this.cid == null && this.getAccountInfo() != null) {
            this.cid = this.accountInfo.getLong("accountId");
        }
        return this.cid;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }
}

